﻿/*
  iocs_mouse.c.c

  functions for compatibility to iocslib
  ( containing mouse oriented functions )

  Made by Studio Breeze. 1998, 2002


  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 */

#include "sted.h"
#include "sted_screen.h"


/* functions */

void
_iocs_ms_curof( void )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  scr->SetMouseCursorVisible(EButtonOff);
  return;
}

void
_iocs_ms_curon( void )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  scr->SetMouseCursorVisible(EButtonOn);
  return;
}

int
_iocs_ms_getdt( void )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  return scr->GetMouseButtonState();
}

void _iocs_ms_init( void )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  scr->MouseInit();
  return;
}

int
_iocs_ms_limit( int in_xs, int in_ys, int in_xe, int in_ye )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  return scr->SetMouseMoveLimit(in_xs, in_ys, in_xe, in_ye);
}

