﻿//
// App.xaml.h
// App クラスの宣言。
//

#pragma once

#include "App.g.h"
#include "SoundDriver.h"
#include "SoundManager.h"

namespace SynthApp
{
	/// <summary>
	/// 既定の Application クラスを補完するアプリケーション固有の動作を提供します。
	/// </summary>
	ref class App sealed
	{
	public:
		App();
    ~App();
		virtual void OnLaunched(Windows::ApplicationModel::Activation::LaunchActivatedEventArgs^ pArgs) override;

	private:
		void OnSuspending(Platform::Object^ sender, Windows::ApplicationModel::SuspendingEventArgs^ e);
    void InitSound();
    void StartSound();
    void StopSound();
    void ExecuteSoundThread();

    bool isDestroy_;
    std::unique_ptr<sf::SoundManager> soundManager_;
    std::unique_ptr<sf::SoundDriver> soundDriver_;
    concurrency::task<void> soundTask_;
    sf::handle_holder soundStopped_;

	};
}
