package lib.property;

import java.io.FileReader;
import java.io.BufferedReader;

public class EasyIni {
    private int line_num = 0;
    private String[] iniData = null;
    public EasyIni(String iniFilePath) {
        iniData = new String[200];
        FileReader fr = null;
        BufferedReader br = null;

        try {
            fr = new FileReader(iniFilePath);
            br = new BufferedReader(fr);

            String line = null;
            // t@CsƂɓǂݍݏInullԂ
            while(true){
                line = br.readLine();
                if(line == null) {
                    break;
                }
                iniData[line_num++] = line;
            }

        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                fr.close();
                br.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
    
    public String getPro(String key) {
        String iniParam = null;
        for(int i = 0;i < line_num;i++) {
            String line = iniData[i];
            if("".equals(line) || line.charAt(0) == ';') {
                continue;
            }
            String[] lineData = line.split("=");
            if(lineData.length != 2) {
                continue;
            }
            String iniKey = lineData[0].trim();
            if(!iniKey.equals(key)) {
                continue;
            }
            iniParam = lineData[1].trim();
            break;
        }
        return iniParam;
    }

}
