$PostCommandParser.CommandList["/dice"] = function(msg,word)
{
	if(word.length == 1)
		text = CastDice("6d1");
	else
		text = CastDice(word[1]);
	return text;
}

function ParseDiceParam(number,option)
{
	if(typeof(number) != "undefined")
	{
		var result = new Object();
		result.option = typeof(option) == "undefined" ? null : option;
		result.number = parseInt(number);
		return result;
	}
	return null;
}

function CastDice(text){
	var p = text.match(/(\d+)D(\d+)C*(\d+)?(\-|\+)?F*(\d+)?(\-|\+)?/i);
	var max = parseInt(p[1]);
	var dice_num = parseInt(p[2]);
	var critical = ParseDiceParam(p[3],p[4]);
	var fanble = ParseDiceParam(p[5],p[6]);
	var total = 0;
	var hasCritical = true;
	var hasFanble = true;
	var util = new Util();

	text = "[" + text + "] -> ";
	for(var i = 0; i < dice_num; i++)
	{
		var t = util.get_random_number(1,max);
		total += t;
		text += t + " + ";

		if(hasCritical && critical != null)
		{
			if(critical.option == "-" && t <= critical.number)
				hasCritical = true;
			else if(critical.option == "+" && t >= critical.number)
				hasCritical = true;
			else if(critical.option == null && t == critical.number)
				hasCritical = true;
			else
				hasCritical = false;
		}

		if(hasFanble && fanble != null)
		{
			if(fanble.option == "-" && t <= fanble.number)
				hasFanble = true;
			else if(fanble.option == "+" && t >= fanble.number)
				hasFanble = true;
			else if(fanble.option == null && t == fanble.number)
				hasFanble = true;
			else
				hasFanble = false;
		}
	}

	text = text.slice(0,text.length - 3);	//Ōɕt" + "菜
	text += " = " + total;

	if(critical == null)
		hasCritical = false;
	if(fanble == null)
		hasFanble = false;

	if(hasCritical)
		text = sprintf($critical_message,text);
	else if(hasFanble)
		text = sprintf($fanble_message,text);

	return text;
}
