package jp.co.headwaters.webappos.generator;

import java.io.File;
import java.io.IOException;

import jp.co.headwaters.webappos.generator.mybatis.ExtraMyBatisGenerator;
import jp.co.headwaters.webappos.generator.utils.FileUtils;
import jp.co.headwaters.webappos.generator.utils.GeneratorUtils;
import jp.co.headwaters.webappos.generator.utils.MessageUtils;
import jp.co.headwaters.webappos.generator.utils.PropertyUtils;
import jp.co.headwaters.webappos.generator.web.JspGenerator;
import jp.co.headwaters.webappos.generator.web.PropertyGenerator;
import jp.co.headwaters.webappos.generator.web.StrutsXmlGenerator;
import jp.co.headwaters.webappos.generator.web.WebAppOSDatGenerator;
import jp.co.headwaters.webappos.generator.web.WebXmlGenerator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Main {
	private static final Log _logger = LogFactory.getLog(Main.class);

	private static String _contextName = null;
	private static String _dbPassword = null;
	private static String _packageName = null;

	public static void main(String[] args) {
		_logger.info("WEB APP OS generate start"); //$NON-NLS-1$
		try {
			// validate
			if (!validate(args)) {
				exit(-1);
			}

			// load generator.properties
			try {
				PropertyUtils.load();
			} catch (IOException e) {
				_logger.error(MessageUtils.getString("err.001"), e); //$NON-NLS-1$
				exit(-2);
			}

			// remake output directory
			clearOutputDirectory();

			// generate jsp
			if (!new JspGenerator().generate()) {
				exit(-3);
			}

			// generate struts.xml
			if (!StrutsXmlGenerator.generate()) {
				exit(-3);
			}

			// generate web.xml
			if (!WebXmlGenerator.generate()) {
				exit(-3);
			}

			// generate webappos.properties
			if (!PropertyGenerator.generate(_contextName, _packageName)) {
				exit(-3);
			}

			// generate MyBatis mapper
			if (!ExtraMyBatisGenerator.generate(_contextName, _dbPassword, _packageName)) {
				exit(-3);
			}

			// generate apache config
			// TODO:β版では実装しない

			// generate webappos.dat
			if (!WebAppOSDatGenerator.generate()) {
				exit(-3);
			}

			exit(0);
		} catch (Exception e) {
			_logger.error(MessageUtils.getString("err.900"), e); //$NON-NLS-1$
			exit(-99);
		}
	}

	private static void exit(int status) {
		_logger.info("WEB APP OS generate end status = " + status); //$NON-NLS-1$
		System.exit(status);
	}

	public static String getContextName() {
		return _contextName;
	}

	private static boolean validate(String[] args) {
		if (args == null || args.length < 2) {
			return false;
		}
		_contextName = args[0];
		_dbPassword = args[1];
		if (args.length >= 3) {
			_packageName = args[2];
		} else {
			StringBuilder sb = new StringBuilder();
			sb.append(GeneratorConstants.SYSTEM_ROOT_PACKAGE);
			sb.append("."); //$NON-NLS-1$
			sb.append(_contextName);
			_packageName = sb.toString();
		}
		return true;
	}

	private static void clearOutputDirectory() {
		FileUtils.deleteFile(new File(GeneratorUtils.getOutputPath()));
		new File(GeneratorUtils.getOutputJspPath()).mkdirs();
		new File(GeneratorUtils.getOutputWebInfPath()).mkdir();
		new File(GeneratorUtils.getOutputSrcPath()).mkdir();
		new File(GeneratorUtils.getOutputPropertyPath()).mkdir();
		new File(GeneratorUtils.getOutputDatPath()).mkdir();
	}
}
