package jp.co.headwaters.webappos.controller.fuction;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.co.headwaters.webappos.controller.ControllerConstants;
import jp.co.headwaters.webappos.controller.cache.bean.AbstractFunctionBean;
import jp.co.headwaters.webappos.controller.cache.bean.ConditionBean;
import jp.co.headwaters.webappos.controller.cache.bean.PagerBean;
import jp.co.headwaters.webappos.controller.cache.bean.SubmitFunctionBean;
import jp.co.headwaters.webappos.controller.enumation.CrudEnum;
import jp.co.headwaters.webappos.controller.exception.NotFoundException;
import jp.co.headwaters.webappos.controller.model.CommonExample;
import jp.co.headwaters.webappos.controller.model.CommonExample.Criteria;
import jp.co.headwaters.webappos.controller.utils.ControllerUtils;
import jp.co.headwaters.webappos.controller.utils.DaoUtils;
import jp.co.headwaters.webappos.controller.utils.MessageUtils;
import jp.co.headwaters.webappos.controller.utils.PagingUtils;
import jp.co.headwaters.webappos.controller.utils.PropertyUtils;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

public class CrudFunction extends AbstractFunction {

	private static final Log _logger = LogFactory.getLog(CrudFunction.class);

	@Override
	protected void execute(AbstractFunctionBean function)
			throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NotFoundException {
		if (CrudEnum.CRUD_SELECT_BY_PRIMARYKEY.getMethod().equals(function.getMethod())
				|| CrudEnum.CRUD_SELECT_ALL_BY_PRIMARYKEY.getMethod().equals(function.getMethod())) {
			//primaryKey = convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(cond.getColumnName()));
		}

		if (CrudEnum.CRUD_SELECT_BY_EXAMPLE.getMethod().equals(function.getMethod())
				|| CrudEnum.CRUD_SELECT_ALL_BY_EXAMPLE.getMethod().equals(function.getMethod())) {
			executeSelectByExample(function);
		}
	}

	private void executeSelectByExample(AbstractFunctionBean function)
			throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NotFoundException {
		@SuppressWarnings("resource")
		SqlSession session = null;
		try {
			String resultName = function.getResult();
			String mapperName = getMapperName(function.getMethod(), function.getTarget());

			CommonExample example = createExample(function);

			session = DaoUtils.getSqlSessionFactory().openSession();
			Integer count = session.selectOne(getMapperName(CrudEnum.CRUD_COUNT.getMethod(), function.getTarget()), example);
			if (count == 0) {
				this._resultMap.put(resultName, new ArrayList<HashMap<String, Object>>());
				return;
			}

			RowBounds rowBounds = createRowBounds(function, count);

			List<?> entityList = null;
			List<HashMap<String, Object>> crudResutlMap = new ArrayList<HashMap<String, Object>>();
			this._resultMap.put(resultName, crudResutlMap);
			if (CrudEnum.CRUD_SELECT_BY_EXAMPLE.getMethod().equals(function.getMethod())) {
				if (rowBounds == null) {
					entityList = session.selectList(mapperName, example);
				} else {
					entityList = session.selectList(mapperName, example, rowBounds);
				}
			} else if (CrudEnum.CRUD_SELECT_ALL_BY_EXAMPLE.getMethod().equals(function.getMethod())) {
				entityList = session.selectList(mapperName, example);
				entityList = entityList.subList(rowBounds.getOffset(), rowBounds.getOffset() + rowBounds.getLimit());
			}

			for (int i = 0; i < entityList.size(); i++) {
				crudResutlMap.add(convertEntityToMap(entityList.get(i), false));
			}
		} finally {
			if (session != null) {
				session.close();
			}
		}
	}

	private static String getMapperName(String method, String target) {
		StringBuilder sb = new StringBuilder();
		sb.append(PropertyUtils.getProperty(ControllerConstants.PROPERTY_KEY_ROOT_PACKAGE));
		sb.append('.');
		sb.append(ControllerConstants.MYBATIS_MAPPER_PACKAGE);
		sb.append('.');
		sb.append(snakeToCamel(target, true));
		sb.append(ControllerConstants.MYBATIS_MAPPER_SUFFIX);
		sb.append('.');
		sb.append(CrudEnum.getCrud(method).getStatementId());
		return sb.toString();
	}

	private CommonExample createExample(AbstractFunctionBean function)
			throws NotFoundException {
		CommonExample example = new CommonExample();
		Criteria criteria = example.createCriteria();
		createConditionFromCache(function, example, criteria);
		if (function instanceof SubmitFunctionBean) {
			createConditionFromRequest((SubmitFunctionBean) function, example, criteria);
		}

		if (StringUtils.isEmpty(example.getOrderByClause())) {
			List<String> sortList = function.getSorts();
			if (sortList != null && sortList.size() > 0) {
				example.setOrderByClause(StringUtils.join(sortList, ",")); //$NON-NLS-1$
			}
		}
		return example;
	}

	private void createConditionFromCache(AbstractFunctionBean function, CommonExample example, Criteria criteria)
			throws NotFoundException {
		if (function.getConds() != null) {
			for (ConditionBean cond : function.getConds()) {
				String[] values = this._requestParams.get(cond.getParamName());
				if (values != null && values.length > 0) {
					values = this._requestParams.get(cond.getParamName());
				} else {
					// リクエストパラメータに存在しない場合、VALUEの値を取得する
					values = new String[1];
					values[0] = cond.getParamValue();
				}

				if (values != null && values.length > 0) {
					createCriteria(function.getResult(),
							cond.getTableName(),
							cond.getColumnName(),
							cond.getOption(),
							cond.getTableName() + '.' + cond.getColumnName(),
							cond.getOperator(),
							values,
							criteria);
				} else {
					_logger.warn(MessageUtils.getString("err.200", cond.getParamName())); //$NON-NLS-1$
					throw new NotFoundException();
				}
			}
		}
	}

	private void createConditionFromRequest(SubmitFunctionBean function, CommonExample example, Criteria criteria) throws NotFoundException {
		String sortElementName = ControllerUtils.getSortElementName(function);
		for (Map.Entry<String, String[]> param : this._requestParams.entrySet()) {
			String[] values = param.getValue();
			if (sortElementName.equals(param.getKey())) {
				example.setOrderByClause(values[0]);
				continue;
			}

			String[] keys = param.getKey().split(ControllerConstants.REQUEST_PARAM_NAME_DELIMITER, 5);
			if (keys.length < 4) {
				continue;
			}
			if (keys[0].equals(function.getResult())) {
				if (ControllerConstants.REQUEST_PARAM_NAME_CRUD_CONDITION.equals(keys[1])) {
					createCriteria(keys, values, function, criteria);
				}
			}
		}
	}

	private void createCriteria(String[] key, String[] values, SubmitFunctionBean function, Criteria criteria) throws NotFoundException {
		// key=0:result識別子,1:cond,2:テーブル名,3:カラム名,4:オプション（オペレータによって異なる）
		String resultName = function.getResult();
		String tableName = key[2];
		String columnName = key[3];
		String option = key[4];
		String target = tableName + '.' + columnName;
		String operator = function.getOperatorMap().get(resultName + '.' + columnName);
		createCriteria(resultName, tableName, columnName, option, target, operator, values, criteria);
	}

	private void createCriteria(String resultName, String tableName, String columnName, String option, String target,
			String operator, String[] values, Criteria criteria) throws NotFoundException {
		Object value = null;
		if (!ControllerConstants.HTML_OPERATOR_NULL.equals(operator)
				&& !ControllerConstants.HTML_OPERATOR_NOT_NULL.equals(operator)
				&& !ControllerConstants.HTML_OPERATOR_BETWEEN.equals(operator)
				&& !ControllerConstants.HTML_OPERATOR_NOT_BETWEEN.equals(operator)) {
			if (StringUtils.isEmpty(values[0])) {
				return;
			}
		}

		if (ControllerConstants.HTML_OPERATOR_NULL.equals(operator)) {
			criteria.andIsNull(target);
		} else if (ControllerConstants.HTML_OPERATOR_NOT_NULL.equals(operator)) {
			criteria.andIsNotNull(target);
		} else if (ControllerConstants.HTML_OPERATOR_EQUAL.equals(operator)) {
			value = convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName));
			criteria.andEqualTo(target, value);
		} else if (ControllerConstants.HTML_OPERATOR_NOT_EQUAL.equals(operator)) {
			value = convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName));
			criteria.andNotEqualTo(target, value);
		} else if (ControllerConstants.HTML_OPERATOR_GREATER_THAN.equals(operator)) {
			value = convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName));
			criteria.andGreaterThan(target, value);
		} else if (ControllerConstants.HTML_OPERATOR_GREATER_OR_EQUAL.equals(operator)) {
			value = convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName));
			criteria.andGreaterThanOrEqualTo(target, value);
		} else if (ControllerConstants.HTML_OPERATOR_LESS_THAN.equals(operator)) {
			value = convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName));
			criteria.andLessThan(target, value);
		} else if (ControllerConstants.HTML_OPERATOR_LESS_OR_EQUAL.equals(operator)) {
			value = convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName));
			criteria.andLessThanOrEqualTo(target, value);
		} else if (ControllerConstants.HTML_OPERATOR_FRONT_LIKE.equals(operator)) {
			criteria.andLike(target, "%" + values[0]); //$NON-NLS-1$
		} else if (ControllerConstants.HTML_OPERATOR_MIDDLE_LIKE.equals(operator)) {
			criteria.andLike(target, "%" + values[0] + "%"); //$NON-NLS-1$ //$NON-NLS-2$
		} else if (ControllerConstants.HTML_OPERATOR_BACK_LIKE.equals(operator)) {
			criteria.andLike(target, values[0] + "%"); //$NON-NLS-1$
		} else if (ControllerConstants.HTML_OPERATOR_FRONT_NOT_LIKE.equals(operator)) {
			criteria.andNotLike(target, "%" + values[0]); //$NON-NLS-1$
		} else if (ControllerConstants.HTML_OPERATOR_MIDDLE_NOT_LIKE.equals(operator)) {
			criteria.andNotLike(target, "%" + values[0] + "%"); //$NON-NLS-1$ //$NON-NLS-2$
		} else if (ControllerConstants.HTML_OPERATOR_BACK_NOT_LIKE.equals(operator)) {
			criteria.andNotLike(target, values[0] + "%"); //$NON-NLS-1$
		} else if (ControllerConstants.HTML_OPERATOR_IN.equals(operator)) {
			List<Object> paramList = new ArrayList<Object>();
			for (String val1 : values) {
				for (String val2 : Arrays.asList(val1.split(ControllerConstants.CRUD_IN_DELIMITER))) {
					if (StringUtils.isEmpty(val2)) {
						continue;
					}
					paramList.add(convertDataType(val2, this._schemaColumnCache.getSchemaColumn(columnName)));
				}
			}
			criteria.andIn(target, paramList);
		} else if (ControllerConstants.HTML_OPERATOR_NOT_IN.equals(operator)) {
			List<Object> paramList = new ArrayList<Object>();
			for (String val1 : values) {
				for (String val2 : Arrays.asList(val1.split(ControllerConstants.CRUD_IN_DELIMITER))) {
					if (StringUtils.isEmpty(val2)) {
						continue;
					}
					paramList.add(convertDataType(val2, this._schemaColumnCache.getSchemaColumn(columnName)));
				}
			}
			criteria.andNotIn(target, paramList);
		} else if (ControllerConstants.HTML_OPERATOR_BETWEEN.equals(operator)) {
			if (ControllerConstants.HTML_OPTION_FROM.equals(option)){
				String[] toValue = this._requestParams.get(getBetweenToName(resultName, tableName, columnName));
				if (!StringUtils.isEmpty(values[0]) && !StringUtils.isEmpty(toValue[0])) {
					criteria.andBetween(target,
							convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName)),
							convertDataType(toValue[0], this._schemaColumnCache.getSchemaColumn(columnName)));
				} else if (!StringUtils.isEmpty(values[0])) {
					value = convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName));
					criteria.andGreaterThanOrEqualTo(target, value);
				} else if (!StringUtils.isEmpty(toValue[0])) {
					value = convertDataType(toValue[0], this._schemaColumnCache.getSchemaColumn(columnName));
					criteria.andLessThanOrEqualTo(target, value);
				}
			}
		} else if (ControllerConstants.HTML_OPERATOR_NOT_BETWEEN.equals(operator)) {
			if (ControllerConstants.HTML_OPTION_FROM.equals(option)){
				String[] toValue = this._requestParams.get(getBetweenToName(resultName, tableName, columnName));

				if (!StringUtils.isEmpty(values[0]) && !StringUtils.isEmpty(toValue[0])) {
					criteria.andNotBetween(target,
							convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName)),
							convertDataType(toValue[0], this._schemaColumnCache.getSchemaColumn(columnName)));
				} else if (!StringUtils.isEmpty(values[0])) {
					value = convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName));
					criteria.andLessThan(target, value);
				} else if (!StringUtils.isEmpty(toValue[0])) {
					value = convertDataType(toValue[0], this._schemaColumnCache.getSchemaColumn(columnName));
					criteria.andGreaterThan(target, value);
				}
			}
		} else {
			_logger.warn(MessageUtils.getString("err.201", operator)); //$NON-NLS-1$
			throw new NotFoundException();
		}
	}

	private String getBetweenToName(String resultName, String tableName, String columnName){
		StringBuilder sb = new StringBuilder();
		sb.append(resultName);
		sb.append(ControllerConstants.REQUEST_PARAM_NAME_DELIMITER);
		sb.append(ControllerConstants.REQUEST_PARAM_NAME_CRUD_CONDITION);
		sb.append(ControllerConstants.REQUEST_PARAM_NAME_DELIMITER);
		sb.append(tableName);
		sb.append(ControllerConstants.REQUEST_PARAM_NAME_DELIMITER);
		sb.append(columnName);
		sb.append(ControllerConstants.REQUEST_PARAM_NAME_DELIMITER);
		sb.append(ControllerConstants.HTML_OPTION_TO);
		return sb.toString();
	}

	private RowBounds createRowBounds(AbstractFunctionBean function, Integer count) {
		RowBounds rowBounds = null;
		int offset = 0;
		int limit = 0;
		PagerBean pager = function.getPager();
		if (pager != null) {
			int pageNo = 0;
			String paramName = ControllerUtils.getPageElementName(function);
			if (this._requestParams.get(paramName) != null
					&& this._requestParams.get(paramName).length > 0
					&& !StringUtils.isEmpty(this._requestParams.get(paramName)[0])) {
				pageNo = Integer.parseInt(this._requestParams.get(paramName)[0]);
			} else {
				pageNo = ControllerConstants.DEFAULT_PEGE_NO;
			}
			PagingUtils pageInfo = new PagingUtils(
											this._resultMap,
											function.getResult(),
											count,
											pageNo,
											Integer.parseInt(pager.getPerPage()),
											Integer.parseInt(pager.getPagerCount()));
			offset = pageInfo.recordBeginNo - 1;
			limit = pageInfo.perPage;
		} else {
			if (!StringUtils.isEmpty(function.getOffset())) {
				offset = Integer.parseInt(function.getOffset());
			}
			if (!StringUtils.isEmpty(function.getLimit())) {
				limit = Integer.parseInt(function.getLimit());
			}
		}
		if (offset != 0 || limit != 0) {
			rowBounds = new RowBounds(offset, limit);
		}
		return rowBounds;
	}











































//	private boolean executeCrudFunction(AbstractFunctionBean function)
//			throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
//
//		String resultName = function.getResult();
//		String mapperName = getMapperName(function.getMethod(), function.getTarget());
//
//		Map<String, Object> daoParams = new HashMap<String, Object>();
//		CommonExample example = new CommonExample();
//		Object primaryKey = null;
//
//		if (CrudEnum.CRUD_SELECT_BY_PRIMARYKEY.getMethod().equals(function.getMethod())
//				|| CrudEnum.CRUD_SELECT_ALL_BY_PRIMARYKEY.getMethod().equals(function.getMethod())
//				|| CrudEnum.CRUD_UPDATE_BY_PRIMARYKEY.getMethod().equals(function.getMethod())
//				|| CrudEnum.CRUD_DELETE_BY_PRIMARYKEY.getMethod().equals(function.getMethod())) {
//			// TODO:PK名は、id固定であることを明記する
//			String[] pkey = _requestParams.get(ControllerConstants.PK_COLUMN_NAME);
//			if (pkey == null) {
//				// TODO：パラメータ不正。エラー画面に遷移するようにする
//				return false;
//			}
//			primaryKey = convertDataType(pkey[0],
//					_schemaColumnCache.getSchemaColumn(ControllerConstants.PK_COLUMN_NAME));
//		}
//
//		if (CrudEnum.CRUD_SELECT_BY_EXAMPLE.getMethod().equals(function.getMethod())
//				|| CrudEnum.CRUD_SELECT_ALL_BY_EXAMPLE.getMethod().equals(function.getMethod())
//				|| CrudEnum.CRUD_INSERT.getMethod().equals(function.getMethod())
//				|| CrudEnum.CRUD_UPDATE.getMethod().equals(function.getMethod())
//				|| CrudEnum.CRUD_UPDATE_BY_PRIMARYKEY.getMethod().equals(function.getMethod())
//				|| CrudEnum.CRUD_DELETE.getMethod().equals(function.getMethod())) {
//			Criteria criteria = null;
//
//			// リクエストパラメータから当該CURD向けのパラメータを抽出する
//			for (Map.Entry<String, String[]> param : _requestParams.entrySet()) {
//				String[] values = param.getValue();
//				String[] key = param.getKey().split(ControllerConstants.REQUEST_PARAM_NAME_DELIMITER, 5);
//				String daoParamKey = null;
//				Object daoParamValue = null;
//
//				if (key[0].equals(resultName)) {
//					if (ControllerConstants.REQUEST_PARAM_NAME_CRUD_COLUMN.equals(key[1])) {
//						// 登録、更新対象カラム
//						daoParamKey = WebAppOSUtils.snakeToCamel(key[2]);
//						// 同名パラメータが存在した場合、先勝ち
//						SchemaColumn schemaColumn = _schemaColumnCache.getSchemaColumn(key[2]);
//						String dataType = schemaColumn.getDataType().toLowerCase();
//
//						if (DataTypeEnum.DATA_TYPE_CHARACTER_VARYING.getDataType().equals(dataType)
//								|| DataTypeEnum.DATA_TYPE_CHARACTER.getDataType().equals(dataType)
//								|| DataTypeEnum.DATA_TYPE_TEXT.getDataType().equals(dataType)) {
//							daoParamValue = StringUtils.join(values, ",");
//						} else {
//							daoParamValue = convertDataType(values[0], schemaColumn);
//						}
//
//						if (!daoParams.containsKey(daoParamKey)) {
//							daoParams.put(daoParamKey, daoParamValue);
//						}
//					} else if (ControllerConstants.REQUEST_PARAM_NAME_CRUD_CONDITION.equals(key[1])) {
//						// パラメータのフォーマットが不正な場合は、無視する
//						if (key.length != 5) {
//							// TODO:ワーニング
//							continue;
//						}
//						if (criteria == null) {
//							criteria = example.createCriteria();
//						}
//						// WHERE条件をDaoExampleに追加する
//						createConditon(key, values, function, criteria);
//					} else if (ControllerConstants.REQUEST_PARAM_NAME_CRUD_SORT.equals(key[1])) {
//						example.setOrderByClause(values[0]);
//					}
//				}
//			}
//		}
//
//		if (StringUtils.isEmpty(example.getOrderByClause())) {
//			if (!StringUtils.isEmpty(function.getOrderBy())) {
//				example.setOrderByClause(function.getOrderBy());
//			}
//		}
//
//		SqlSession session = DaoUtils.getSqlSessionFactory().openSession();
//		try {
//			if (CrudEnum.CRUD_SELECT_BY_PRIMARYKEY.getMethod().equals(function.getMethod())) {
//				session = DaoUtils.getSqlSessionFactory().openSession();
//				AbstractEntity resultEntity = session.selectOne(mapperName, primaryKey);
//				_resultMap.put(resultName, convertEntityToMap(resultEntity, false));
//			} else if (CrudEnum.CRUD_SELECT_ALL_BY_PRIMARYKEY.getMethod().equals(function.getMethod())) {
//				session = DaoUtils.getSqlSessionFactory().openSession();
//				AbstractEntity resultEntity = session.selectOne(mapperName, primaryKey);
//				if (resultEntity == null) {
//					_resultMap.put(resultName, new HashMap<String, String>());
//				} else {
//					_resultMap.put(resultName, convertEntityToMap(resultEntity, true));
//				}
//			} else if (CrudEnum.CRUD_SELECT_BY_EXAMPLE.getMethod().equals(function.getMethod())) {
//				session = DaoUtils.getSqlSessionFactory().openSession();
//				List<?> entityList = session.selectList(mapperName, example);
//				List<HashMap<String, Object>> crudResutlMap = new ArrayList<HashMap<String, Object>>();
//				_resultMap.put(resultName, crudResutlMap);
//				for (int i = 0; i < entityList.size(); i++) {
//					crudResutlMap.add(convertEntityToMap(entityList.get(i), false));
//				}
//			} else if (CrudEnum.CRUD_SELECT_ALL_BY_EXAMPLE.getMethod().equals(function.getMethod())) {
//				session = DaoUtils.getSqlSessionFactory().openSession();
//				List<?> entityList = session.selectList(mapperName, example);
//				List<HashMap<String, Object>> crudResutlMap = new ArrayList<HashMap<String, Object>>();
//				_resultMap.put(resultName, crudResutlMap);
//				for (int i = 0; i < entityList.size(); i++) {
//					crudResutlMap.add(convertEntityToMap(entityList.get(i), true));
//				}
//			} else if (CrudEnum.CRUD_INSERT.getMethod().equals(function.getMethod())) {
//				session = DaoUtils.getSqlSessionFactory().openSession(true);
//				Map<String, Object> insertMap = new HashMap<String, Object>();
//				daoParams.put("created", new Timestamp(System.currentTimeMillis()));
//				daoParams.put("updated", new Timestamp(System.currentTimeMillis()));
//				insertMap.put("record", daoParams);
//				// TODO:created、updatedをセット
//				session.insert(mapperName, insertMap);
//			} else if (CrudEnum.CRUD_UPDATE.getMethod().equals(function.getMethod())) {
//				if (example == null || example.getOredCriteria().size() == 0) {
//					// TODO:条件なし。。
//					return false;
//				}
//				session = DaoUtils.getSqlSessionFactory().openSession(true);
//				Map<String, Object> updateMap = new HashMap<String, Object>();
//				daoParams.put("updated", new Timestamp(System.currentTimeMillis()));
//				updateMap.put("record", daoParams);
//				updateMap.put("example", example);
//				session.update(mapperName, updateMap);
//			} else if (CrudEnum.CRUD_UPDATE_BY_PRIMARYKEY.getMethod().equals(function.getMethod())) {
//				session = DaoUtils.getSqlSessionFactory().openSession(true);
//				Map<String, Object> updateMap = new HashMap<String, Object>();
//				daoParams.put("updated", new Timestamp(System.currentTimeMillis()));
//				updateMap.put("record", daoParams);
//				updateMap.put("id", primaryKey);
//				session.update(mapperName, updateMap);
//			} else if (CrudEnum.CRUD_DELETE.getMethod().equals(function.getMethod())) {
//				if (example == null || example.getOredCriteria().size() == 0) {
//					// TODO:条件なし。。
//					return false;
//				}
//				session = DaoUtils.getSqlSessionFactory().openSession(true);
//				session.delete(mapperName, example);
//			} else if (CrudEnum.CRUD_DELETE_BY_PRIMARYKEY.getMethod().equals(function.getMethod())) {
//				session = DaoUtils.getSqlSessionFactory().openSession(true);
//				session.delete(mapperName, primaryKey);
//			}
//		} finally {
//			if (session != null) {
//				session.close();
//			}
//		}
//		return true;
//	}
}
