package jp.co.headwaters.webappos.controller.enumation;

/**
 * DBのデータ型を表す列挙子
 */
public enum DataTypeEnum {

	DATA_TYPE_SMALLINT("smallint"), //$NON-NLS-1$
	DATA_TYPE_INTEGER("integer"), //$NON-NLS-1$
	DATA_TYPE_BIGINT("bigint"), //$NON-NLS-1$
	DATA_TYPE_NUMERIC("numeric"), //$NON-NLS-1$
	DATA_TYPE_REAL("real"), //$NON-NLS-1$
	DATA_TYPE_DOUBLE_PRECISION("double precision"), //$NON-NLS-1$
	DATA_TYPE_CHARACTER_VARYING("character varying"), //$NON-NLS-1$
	DATA_TYPE_CHARACTER("character"), //$NON-NLS-1$
	DATA_TYPE_TEXT("text"), //$NON-NLS-1$
	DATA_TYPE_TIMESTAMP_WITHOUT_TIME_ZONE("timestamp without time zone"), //$NON-NLS-1$
	DATA_TYPE_TIMESTAMP_WITH_TIME_ZONE("timestamp with time zone"), //$NON-NLS-1$
	DATA_TYPE_DATE("date"), //$NON-NLS-1$
	DATA_TYPE_TIME_WITHOUT_TIME_ZONE("time without time zone"), //$NON-NLS-1$
	DATA_TYPE_TIME_WITH_TIME_ZONE("time with time zone"), //$NON-NLS-1$
	DATA_TYPE_BYTEA("bytea"), //$NON-NLS-1$
	DATA_TYPE_BOOLEAN("boolean"), //$NON-NLS-1$
	DATA_TYPE_BIT("bit"), //$NON-NLS-1$
	DATA_TYPE_BIT_VARYING("bit varying"); //$NON-NLS-1$

	private String type;

	private DataTypeEnum(final String type) {
		this.type = type;
	}

	public static DataTypeEnum getDataType(final String type) {
		for (DataTypeEnum e : DataTypeEnum.values()) {
			if (type.equals(e.getDataType())) {
				return e;
			}
		}
		throw new IllegalArgumentException(type);
	}

	public String getDataType() {
		return this.type;
	}
}
