/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.CookiesAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 4153142432948747305L;
    private static final Logger LOG = LoggerFactory.getLogger(CookieInterceptor.class);
    private static final String ACCEPTED_PATTERN = "[a-zA-Z0-9\\.\\]\\[_'\\s]+";
    private Set<String> cookiesNameSet = Collections.emptySet();
    private Set<String> cookiesValueSet = Collections.emptySet();
    private Pattern acceptedPattern = Pattern.compile("[a-zA-Z0-9\\.\\]\\[_'\\s]+");

    public void setCookiesName(String cookiesName) {
        if (cookiesName != null) {
            this.cookiesNameSet = TextParseUtil.commaDelimitedStringToSet((String)cookiesName);
        }
    }

    public void setCookiesValue(String cookiesValue) {
        if (cookiesValue != null) {
            this.cookiesValueSet = TextParseUtil.commaDelimitedStringToSet((String)cookiesValue);
        }
    }

    public void setAcceptCookieNames(String pattern) {
        this.acceptedPattern = Pattern.compile(pattern);
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("start interception", new String[0]);
        }
        LinkedHashMap<String, String> cookiesMap = new LinkedHashMap<String, String>();
        Cookie[] cookies = ServletActionContext.getRequest().getCookies();
        if (cookies != null) {
            ValueStack stack = ActionContext.getContext().getValueStack();
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                String value = cookie.getValue();
                if (this.acceptedPattern.matcher(name).matches()) {
                    if (this.cookiesNameSet.contains("*")) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("contains cookie name [*] in configured cookies name set, cookie with name [" + name + "] with value [" + value + "] will be injected", new String[0]);
                        }
                        this.populateCookieValueIntoStack(name, value, cookiesMap, stack);
                        continue;
                    }
                    if (!this.cookiesNameSet.contains(cookie.getName())) continue;
                    this.populateCookieValueIntoStack(name, value, cookiesMap, stack);
                    continue;
                }
                LOG.warn("Cookie name [" + name + "] does not match accepted cookie names pattern [" + this.acceptedPattern + "]", new String[0]);
            }
        }
        this.injectIntoCookiesAwareAction(invocation.getAction(), cookiesMap);
        return invocation.invoke();
    }

    protected void populateCookieValueIntoStack(String cookieName, String cookieValue, Map<String, String> cookiesMap, ValueStack stack) {
        if (this.cookiesValueSet.isEmpty() || this.cookiesValueSet.contains("*")) {
            if (LOG.isDebugEnabled()) {
                if (this.cookiesValueSet.isEmpty()) {
                    LOG.debug("no cookie value is configured, cookie with name [" + cookieName + "] with value [" + cookieValue + "] will be injected", new String[0]);
                } else if (this.cookiesValueSet.contains("*")) {
                    LOG.debug("interceptor is configured to accept any value, cookie with name [" + cookieName + "] with value [" + cookieValue + "] will be injected", new String[0]);
                }
            }
            cookiesMap.put(cookieName, cookieValue);
            stack.setValue(cookieName, (Object)cookieValue);
        } else if (this.cookiesValueSet.contains(cookieValue)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("both configured cookie name and value matched, cookie [" + cookieName + "] with value [" + cookieValue + "] will be injected", new String[0]);
            }
            cookiesMap.put(cookieName, cookieValue);
            stack.setValue(cookieName, (Object)cookieValue);
        }
    }

    protected void injectIntoCookiesAwareAction(Object action, Map<String, String> cookiesMap) {
        if (action instanceof CookiesAware) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("action [" + action + "] implements CookiesAware, injecting cookies map [" + cookiesMap + "]", new String[0]);
            }
            ((CookiesAware)action).setCookiesMap(cookiesMap);
        }
    }
}

