/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

public class ByteConverter {
    private ByteConverter() {
    }

    public static long int8(byte[] bytes, int idx) {
        return ((long)(bytes[idx + 0] & 0xFF) << 56) + ((long)(bytes[idx + 1] & 0xFF) << 48) + ((long)(bytes[idx + 2] & 0xFF) << 40) + ((long)(bytes[idx + 3] & 0xFF) << 32) + ((long)(bytes[idx + 4] & 0xFF) << 24) + ((long)(bytes[idx + 5] & 0xFF) << 16) + ((long)(bytes[idx + 6] & 0xFF) << 8) + (long)(bytes[idx + 7] & 0xFF);
    }

    public static int int4(byte[] bytes, int idx) {
        return ((bytes[idx] & 0xFF) << 24) + ((bytes[idx + 1] & 0xFF) << 16) + ((bytes[idx + 2] & 0xFF) << 8) + (bytes[idx + 3] & 0xFF);
    }

    public static short int2(byte[] bytes, int idx) {
        return (short)(((bytes[idx] & 0xFF) << 8) + (bytes[idx + 1] & 0xFF));
    }

    public static float float4(byte[] bytes, int idx) {
        return Float.intBitsToFloat(ByteConverter.int4(bytes, idx));
    }

    public static double float8(byte[] bytes, int idx) {
        return Double.longBitsToDouble(ByteConverter.int8(bytes, idx));
    }

    public static void int8(byte[] target, int idx, long value) {
        target[idx + 0] = (byte)(value >>> 56);
        target[idx + 1] = (byte)(value >>> 48);
        target[idx + 2] = (byte)(value >>> 40);
        target[idx + 3] = (byte)(value >>> 32);
        target[idx + 4] = (byte)(value >>> 24);
        target[idx + 5] = (byte)(value >>> 16);
        target[idx + 6] = (byte)(value >>> 8);
        target[idx + 7] = (byte)value;
    }

    public static void int4(byte[] target, int idx, int value) {
        target[idx + 0] = (byte)(value >>> 24);
        target[idx + 1] = (byte)(value >>> 16);
        target[idx + 2] = (byte)(value >>> 8);
        target[idx + 3] = (byte)value;
    }

    public static void int2(byte[] target, int idx, int value) {
        target[idx + 0] = (byte)(value >>> 8);
        target[idx + 1] = (byte)value;
    }

    public static void float4(byte[] target, int idx, float value) {
        ByteConverter.int4(target, idx, Float.floatToRawIntBits(value));
    }

    public static void float8(byte[] target, int idx, double value) {
        ByteConverter.int8(target, idx, Double.doubleToRawLongBits(value));
    }
}

