package jp.co.headwaters.webappos.controller.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import jp.co.headwaters.webappos.controller.ControllerConstants;

public class PropertyUtils {

	private static Properties configuration = new Properties();

	private PropertyUtils() {
	}

	public static void load() throws IOException {
		try (
				InputStream inputStream = PropertyUtils.class.getResourceAsStream("/" //$NON-NLS-1$
						+ ControllerConstants.PROPERTY_FILE_NAME)) {
			configuration.load(inputStream);
		}
	}

	public static String getProperty(String key) {
		return configuration.getProperty(key);
	}

	public static void putProperty(String key, String value) {
		configuration.put(key, value);
	}
}