package jp.co.headwaters.webappos.common.enumation;

/**
 * CRUD処理を表す列挙子
 */
public enum CrudEnum {

	/** keyを指定してレコードを取得する(対象テーブルのみ) */
	CRUD_SELECT_BY_PRIMARYKEY("selectByPrimaryKey"),
	/** keyを指定してレコードを取得する(参照テーブル含む) */
	CRUD_SELECT_ALL_BY_PRIMARYKEY("selectAllByPrimaryKey"),
	/** Exampleを指定してレコードを取得する(対象テーブルのみ) */
	CRUD_SELECT_BY_EXAMPLE("selectByExample"),
	/** Exampleを指定してレコードを取得する(参照テーブル含む) */
	CRUD_SELECT_ALL_BY_EXAMPLE("selectAllByExample"),
	/** 登録 */
	CRUD_INSERT("insert"),
	/** Exampleを指定して更新する */
	CRUD_UPDATE("update"),
	/** keyを指定して更新する */
	CRUD_UPDATE_BY_PRIMARYKEY("updateByPrimaryKey"),
	/** Exampleを指定して削除する */
	CRUD_DELETE("delete"),
	/** keyを指定して削除する */
	CRUD_DELETE_BY_PRIMARYKEY("deleteByPrimaryKey");

	private String type;

	private CrudEnum(final String type) {
		this.type = type;
	}

	public static CrudEnum getType(final String type) {
		for (CrudEnum e : CrudEnum.values()) {
			if (type.equals(e.getType())) {
				return e;
			}
		}
		throw new IllegalArgumentException(type);
	}

	public String getType() {
		return this.type;
	}

}
