/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.logging.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.jdbc.BaseJdbcLogger;
import org.apache.ibatis.logging.jdbc.PreparedStatementLogger;
import org.apache.ibatis.logging.jdbc.StatementLogger;
import org.apache.ibatis.reflection.ExceptionUtil;

public final class ConnectionLogger
extends BaseJdbcLogger
implements InvocationHandler {
    private Connection connection;

    private ConnectionLogger(Connection conn, Log statementLog) {
        super(statementLog);
        this.connection = conn;
        if (this.isDebugEnabled()) {
            this.debug("ooo Using Connection [" + conn + "]");
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        try {
            if ("prepareStatement".equals(method.getName())) {
                if (this.isDebugEnabled()) {
                    this.debug("==>  Preparing: " + this.removeBreakingWhitespace((String)params[0]));
                }
                PreparedStatement stmt = (PreparedStatement)method.invoke((Object)this.connection, params);
                stmt = PreparedStatementLogger.newInstance(stmt, this.getStatementLog());
                return stmt;
            }
            if ("prepareCall".equals(method.getName())) {
                if (this.isDebugEnabled()) {
                    this.debug("==>  Preparing: " + this.removeBreakingWhitespace((String)params[0]));
                }
                PreparedStatement stmt = (PreparedStatement)method.invoke((Object)this.connection, params);
                stmt = PreparedStatementLogger.newInstance(stmt, this.getStatementLog());
                return stmt;
            }
            if ("createStatement".equals(method.getName())) {
                Statement stmt = (Statement)method.invoke((Object)this.connection, params);
                stmt = StatementLogger.newInstance(stmt, this.getStatementLog());
                return stmt;
            }
            if ("close".equals(method.getName())) {
                if (this.isDebugEnabled()) {
                    this.debug("xxx Connection Closed");
                }
                return method.invoke((Object)this.connection, params);
            }
            return method.invoke((Object)this.connection, params);
        }
        catch (Throwable t) {
            throw ExceptionUtil.unwrapThrowable(t);
        }
    }

    public static Connection newInstance(Connection conn, Log statementLog) {
        ConnectionLogger handler = new ConnectionLogger(conn, statementLog);
        ClassLoader cl = Connection.class.getClassLoader();
        return (Connection)Proxy.newProxyInstance(cl, new Class[]{Connection.class}, (InvocationHandler)handler);
    }

    public Connection getConnection() {
        return this.connection;
    }
}

