package jp.co.headwaters.webappos.controller.fuction;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import jp.co.headwaters.webappos.controller.ControllerConstants;
import jp.co.headwaters.webappos.controller.cache.bean.AbstractFunctionBean;
import jp.co.headwaters.webappos.controller.cache.bean.ConditionBean;
import jp.co.headwaters.webappos.controller.cache.bean.LoadFunctionBean;
import jp.co.headwaters.webappos.controller.cache.bean.PagerBean;
import jp.co.headwaters.webappos.controller.cache.bean.SubmitFunctionBean;
import jp.co.headwaters.webappos.controller.enumation.CrudEnum;
import jp.co.headwaters.webappos.controller.model.AbstractEntity;
import jp.co.headwaters.webappos.controller.model.CommonExample;
import jp.co.headwaters.webappos.controller.model.CommonExample.Criteria;
import jp.co.headwaters.webappos.controller.utils.DaoUtils;
import jp.co.headwaters.webappos.controller.utils.PagingUtils;
import jp.co.headwaters.webappos.controller.utils.PropertyUtils;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

public class CrudFunction extends AbstractFunction {

	@Override
	protected void execute(AbstractFunctionBean function) throws Exception {
		if (function instanceof SubmitFunctionBean){
			// submit
		} else {
			// load
			executeLoadFunction((LoadFunctionBean) function);
		}
	}

	private void executeLoadFunction(LoadFunctionBean function)
			throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
		if (!CrudEnum.CRUD_SELECT_BY_PRIMARYKEY.getMethod().equals(function.getMethod())
				&& !CrudEnum.CRUD_SELECT_ALL_BY_PRIMARYKEY.getMethod().equals(function.getMethod())
				&& !CrudEnum.CRUD_SELECT_BY_EXAMPLE.getMethod().equals(function.getMethod())
				&& !CrudEnum.CRUD_SELECT_ALL_BY_EXAMPLE.getMethod().equals(function.getMethod())) {
			// TODO:WARN
			return;
		}

		String resultName = function.getResult();
		String mapperName = getMapperName(function.getMethod(), function.getTarget());

		CommonExample example = null;
		Object primaryKey = null;

		if (!this._resultMap.containsKey("request")){
			this._resultMap.put("request", new HashMap<String, String>());
		}

		@SuppressWarnings("unchecked")
		HashMap<String ,Object> requestMap = (HashMap<String, Object>) this._resultMap.get("request");

		example = new CommonExample();
		Criteria criteria = null;
		if (function.getConds() != null){
			for (ConditionBean cond : function.getConds()) {
				if (criteria == null){
					criteria = example.createCriteria();
				}

				String[] values = this._requestParams.get(cond.getParamName());
				if (values != null && values.length > 0) {
					values = this._requestParams.get(cond.getParamName());
				} else {
					// リクエストパラメータに存在しない場合
					values = new String[1];
					values[0] = cond.getParamValue();
				}

				if (values != null && values.length > 0) {
					requestMap.put(cond.getParamName(), values[0]);

					if (CrudEnum.CRUD_SELECT_BY_PRIMARYKEY.getMethod().equals(function.getMethod())
							|| CrudEnum.CRUD_SELECT_ALL_BY_PRIMARYKEY.getMethod().equals(function.getMethod())) {
						primaryKey = convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(cond.getColumnName()));
					} else {
						createConditon(function.getResult(),
								cond.getTableName(),
								cond.getColumnName(),
								cond.getOption(),
								cond.getTableName() + "." + cond.getColumnName(),
								cond.getOperator(),
								values,
								criteria);
					}
				} else {
					requestMap.put(cond.getParamName(), "");
				}
			}
		}

		List<String> sortList = function.getSorts();
		if (sortList != null && sortList.size() > 0) {
			example.setOrderByClause(StringUtils.join(sortList, ","));
		}

		SqlSession session = DaoUtils.getSqlSessionFactory().openSession();
		try {
			if (CrudEnum.CRUD_SELECT_BY_PRIMARYKEY.getMethod().equals(function.getMethod())) {
				session = DaoUtils.getSqlSessionFactory().openSession();
				AbstractEntity resultEntity = session.selectOne(mapperName, primaryKey);
				if (resultEntity == null){
					this._resultMap.put(resultName, new HashMap<String, String>());
				}else{
					this._resultMap.put(resultName, convertEntityToMap(resultEntity, false));
				}
			} else if (CrudEnum.CRUD_SELECT_ALL_BY_PRIMARYKEY.getMethod().equals(function.getMethod())) {
				session = DaoUtils.getSqlSessionFactory().openSession();
				AbstractEntity resultEntity = session.selectOne(mapperName, primaryKey);
				this._resultMap.put(resultName, convertEntityToMap(resultEntity, true));
			} else if (CrudEnum.CRUD_SELECT_BY_EXAMPLE.getMethod().equals(function.getMethod())) {
				session = DaoUtils.getSqlSessionFactory().openSession();
				Integer count = session.selectOne(getMapperName(CrudEnum.CRUD_COUNT.getMethod(), function.getTarget()), example);

				if (count > 0) {
					List<?> entityList = null;
					int pageNo = 0;
					int offset = 0;
					int limit = 0;
					RowBounds rowBounds = null;
					PagerBean pager = function.getPager();
					if (pager != null){
						if (this._requestParams.get("pageNo") != null
								&& this._requestParams.get("pageNo").length > 0
								&& !StringUtils.isEmpty(this._requestParams.get("pageNo")[0])) {
							pageNo = Integer.parseInt(this._requestParams.get("pageNo")[0]);
						} else {
							pageNo = 1;
						}
						requestMap.put("pageNo", pageNo);

						PagingUtils pageInfo = new PagingUtils(
								this._resultMap, resultName,
								count, pageNo,
								Integer.parseInt(pager.getPerPage()), Integer.parseInt(pager.getPagerCount()));

						// pageNoを元にoffsetとlimitを算出する
						offset = pageInfo.recordBeginNo - 1;
						limit = pageInfo.perPage;
					} else {
						if (!StringUtils.isEmpty(function.getOffset())) {
							offset = Integer.parseInt(function.getOffset());
						}
						if (!StringUtils.isEmpty(function.getLimit())) {
							limit = Integer.parseInt(function.getLimit());
						}
					}

					if (offset != 0 || limit != 0) {
						rowBounds = new RowBounds(offset, limit);
					}
					if (rowBounds == null) {
						entityList = session.selectList(mapperName, example);
					} else {
						entityList = session.selectList(mapperName, example, rowBounds);
					}
					List<HashMap<String, Object>> crudResutlMap = new ArrayList<HashMap<String, Object>>();
					this._resultMap.put(resultName, crudResutlMap);
					for (int i = 0; i < entityList.size(); i++) {
						crudResutlMap.add(convertEntityToMap(entityList.get(i), false));
					}
				} else {
					this._resultMap.put(resultName, new ArrayList<HashMap<String, Object>>());
				}
			} else if (CrudEnum.CRUD_SELECT_ALL_BY_EXAMPLE.getMethod().equals(function.getMethod())) {
				session = DaoUtils.getSqlSessionFactory().openSession();
				// TODO:ページャー
				List<?> entityList = session.selectList(mapperName, example);
				List<HashMap<String, Object>> crudResutlMap = new ArrayList<HashMap<String, Object>>();
				this._resultMap.put(resultName, crudResutlMap);
				for (int i = 0; i < entityList.size(); i++) {
					crudResutlMap.add(convertEntityToMap(entityList.get(i), true));
				}
			}
		} finally {
			if (session != null) {
				session.close();
			}
		}
	}

//	private boolean executeCrudFunction(AbstractFunctionBean function)
//	throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
//
//String resultName = function.getResult();
//String mapperName = getMapperName(function.getMethod(), function.getTarget());
//
//Map<String, Object> daoParams = new HashMap<String, Object>();
//CommonExample example = new CommonExample();
//Object primaryKey = null;
//
//if (CrudEnum.CRUD_SELECT_BY_PRIMARYKEY.getMethod().equals(function.getMethod())
//		|| CrudEnum.CRUD_SELECT_ALL_BY_PRIMARYKEY.getMethod().equals(function.getMethod())
//		|| CrudEnum.CRUD_UPDATE_BY_PRIMARYKEY.getMethod().equals(function.getMethod())
//		|| CrudEnum.CRUD_DELETE_BY_PRIMARYKEY.getMethod().equals(function.getMethod())) {
//	// TODO:PK名は、id固定であることを明記する
//	String[] pkey = _requestParams.get(ControllerConstants.PK_COLUMN_NAME);
//	if (pkey == null) {
//		// TODO：パラメータ不正。エラー画面に遷移するようにする
//		return false;
//	}
//	primaryKey = convertDataType(pkey[0], _schemaColumnCache.getSchemaColumn(ControllerConstants.PK_COLUMN_NAME));
//}
//
//if (CrudEnum.CRUD_SELECT_BY_EXAMPLE.getMethod().equals(function.getMethod())
//		|| CrudEnum.CRUD_SELECT_ALL_BY_EXAMPLE.getMethod().equals(function.getMethod())
//		|| CrudEnum.CRUD_INSERT.getMethod().equals(function.getMethod())
//		|| CrudEnum.CRUD_UPDATE.getMethod().equals(function.getMethod())
//		|| CrudEnum.CRUD_UPDATE_BY_PRIMARYKEY.getMethod().equals(function.getMethod())
//		|| CrudEnum.CRUD_DELETE.getMethod().equals(function.getMethod())) {
//	Criteria criteria = null;
//
//	// リクエストパラメータから当該CURD向けのパラメータを抽出する
//	for (Map.Entry<String, String[]> param : _requestParams.entrySet()) {
//		String[] values = param.getValue();
//		String[] key = param.getKey().split(ControllerConstants.REQUEST_PARAM_NAME_DELIMITER, 5);
//		String daoParamKey = null;
//		Object daoParamValue = null;
//
//		if (key[0].equals(resultName)) {
//			if (ControllerConstants.REQUEST_PARAM_NAME_CRUD_COLUMN.equals(key[1])) {
//				// 登録、更新対象カラム
//				daoParamKey =  WebAppOSUtils.snakeToCamel(key[2]);
//				// 同名パラメータが存在した場合、先勝ち
//				SchemaColumn schemaColumn = _schemaColumnCache.getSchemaColumn(key[2]);
//				String dataType = schemaColumn.getDataType().toLowerCase();
//
//				if (DataTypeEnum.DATA_TYPE_CHARACTER_VARYING.getDataType().equals(dataType)
//						|| DataTypeEnum.DATA_TYPE_CHARACTER.getDataType().equals(dataType)
//						|| DataTypeEnum.DATA_TYPE_TEXT.getDataType().equals(dataType)) {
//					daoParamValue = StringUtils.join(values, ",");
//				}else{
//					daoParamValue = convertDataType(values[0], schemaColumn);
//				}
//
//				if (!daoParams.containsKey(daoParamKey)) {
//					daoParams.put(daoParamKey, daoParamValue);
//				}
//			} else if (ControllerConstants.REQUEST_PARAM_NAME_CRUD_CONDITION.equals(key[1])) {
//				// パラメータのフォーマットが不正な場合は、無視する
//				if (key.length != 5) {
//					// TODO:ワーニング
//					continue;
//				}
//				if (criteria == null){
//					criteria = example.createCriteria();
//				}
//				// WHERE条件をDaoExampleに追加する
//				createConditon(key, values, function, criteria);
//			} else if (ControllerConstants.REQUEST_PARAM_NAME_CRUD_SORT.equals(key[1])) {
//				example.setOrderByClause(values[0]);
//			}
//		}
//	}
//}
//
//if (StringUtils.isEmpty(example.getOrderByClause())) {
//	if (!StringUtils.isEmpty(function.getOrderBy())) {
//		example.setOrderByClause(function.getOrderBy());
//	}
//}
//
//SqlSession session = DaoUtils.getSqlSessionFactory().openSession();
//try {
//	if (CrudEnum.CRUD_SELECT_BY_PRIMARYKEY.getMethod().equals(function.getMethod())) {
//		session = DaoUtils.getSqlSessionFactory().openSession();
//		AbstractEntity resultEntity = session.selectOne(mapperName, primaryKey);
//		_resultMap.put(resultName, convertEntityToMap(resultEntity, false));
//	} else if (CrudEnum.CRUD_SELECT_ALL_BY_PRIMARYKEY.getMethod().equals(function.getMethod())) {
//		session = DaoUtils.getSqlSessionFactory().openSession();
//		AbstractEntity resultEntity = session.selectOne(mapperName, primaryKey);
//		if (resultEntity == null){
//			_resultMap.put(resultName, new HashMap<String, String>());
//		}else{
//			_resultMap.put(resultName, convertEntityToMap(resultEntity, true));
//		}
//	} else if (CrudEnum.CRUD_SELECT_BY_EXAMPLE.getMethod().equals(function.getMethod())) {
//		session = DaoUtils.getSqlSessionFactory().openSession();
//		List<?> entityList = session.selectList(mapperName, example);
//		List<HashMap<String, Object>> crudResutlMap = new ArrayList<HashMap<String, Object>>();
//		_resultMap.put(resultName, crudResutlMap);
//		for (int i = 0; i < entityList.size(); i++) {
//			crudResutlMap.add(convertEntityToMap(entityList.get(i), false));
//		}
//	} else if (CrudEnum.CRUD_SELECT_ALL_BY_EXAMPLE.getMethod().equals(function.getMethod())) {
//		session = DaoUtils.getSqlSessionFactory().openSession();
//		List<?> entityList = session.selectList(mapperName, example);
//		List<HashMap<String, Object>> crudResutlMap = new ArrayList<HashMap<String, Object>>();
//		_resultMap.put(resultName, crudResutlMap);
//		for (int i = 0; i < entityList.size(); i++) {
//			crudResutlMap.add(convertEntityToMap(entityList.get(i), true));
//		}
//	} else if (CrudEnum.CRUD_INSERT.getMethod().equals(function.getMethod())) {
//		session = DaoUtils.getSqlSessionFactory().openSession(true);
//		Map<String, Object> insertMap = new HashMap<String, Object>();
//		daoParams.put("created", new Timestamp(System.currentTimeMillis()));
//		daoParams.put("updated", new Timestamp(System.currentTimeMillis()));
//		insertMap.put("record", daoParams);
//		// TODO:created、updatedをセット
//		session.insert(mapperName, insertMap);
//	} else if (CrudEnum.CRUD_UPDATE.getMethod().equals(function.getMethod())) {
//		if (example == null || example.getOredCriteria().size() == 0) {
//			// TODO:条件なし。。
//			return false;
//		}
//		session = DaoUtils.getSqlSessionFactory().openSession(true);
//		Map<String, Object> updateMap = new HashMap<String, Object>();
//		daoParams.put("updated", new Timestamp(System.currentTimeMillis()));
//		updateMap.put("record", daoParams);
//		updateMap.put("example", example);
//		session.update(mapperName, updateMap);
//	} else if (CrudEnum.CRUD_UPDATE_BY_PRIMARYKEY.getMethod().equals(function.getMethod())) {
//		session = DaoUtils.getSqlSessionFactory().openSession(true);
//		Map<String, Object> updateMap = new HashMap<String, Object>();
//		daoParams.put("updated", new Timestamp(System.currentTimeMillis()));
//		updateMap.put("record", daoParams);
//		updateMap.put("id", primaryKey);
//		session.update(mapperName, updateMap);
//	} else if (CrudEnum.CRUD_DELETE.getMethod().equals(function.getMethod())) {
//		if (example == null || example.getOredCriteria().size() == 0) {
//			// TODO:条件なし。。
//			return false;
//		}
//		session = DaoUtils.getSqlSessionFactory().openSession(true);
//		session.delete(mapperName, example);
//	} else if (CrudEnum.CRUD_DELETE_BY_PRIMARYKEY.getMethod().equals(function.getMethod())) {
//		session = DaoUtils.getSqlSessionFactory().openSession(true);
//		session.delete(mapperName, primaryKey);
//	}
//} finally {
//	if (session != null) {
//		session.close();
//	}
//}
//return true;
//}

	private void createConditon(String[] key, String[] values, AbstractFunctionBean function, Criteria criteria) {
		// key=0:result識別子,1:cond,2:テーブル名,3:カラム名,4:オプション（オペレータによって異なる）
		String resultName = function.getResult();
		String tableName = key[2];
		String columnName = key[3];
		String option = key[4];
		String target = tableName + "." + columnName;
		// TODO
//		String operator = function.getCondMap().get(tableName + columnName);
		String operator = null;

		createConditon(resultName, tableName, columnName, option, target, operator, values, criteria);
	}

	private void createConditon(String resultName, String tableName, String columnName, String option, String target,
			String operator, String[] values, Criteria criteria) {
		Object value = null;
		if (!"isnull".equals(operator)
				&& !"isnotnull".equals(operator)
				&& !"between".equals(operator)
				&& !"notbetween".equals(operator)) {
			if (StringUtils.isEmpty(values[0])) {
				return;
			}
		}

		// TODO:後で定数にする
		if ("isnull".equals(operator)) {
			criteria.andIsNull(target);
		} else if ("isnotnull".equals(operator)) {
			criteria.andIsNotNull(target);
		} else if ("eq".equals(operator)) {
			value = convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName));
			criteria.andEqualTo(target, value);
		} else if ("nq".equals(operator)) {
			value = convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName));
			criteria.andNotEqualTo(target, value);
		} else if ("gt".equals(operator)) {
			value = convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName));
			criteria.andGreaterThan(target, value);
		} else if ("ge".equals(operator)) {
			value = convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName));
			criteria.andGreaterThanOrEqualTo(target, value);
		} else if ("lt".equals(operator)) {
			value = convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName));
			criteria.andLessThan(target, value);
		} else if ("le".equals(operator)) {
			value = convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName));
			criteria.andLessThanOrEqualTo(target, value);
		} else if ("%like".equals(operator)) {
			criteria.andLike(target, "%" + values[0]);
		} else if ("%like%".equals(operator)) {
			criteria.andLike(target, "%" + values[0] + "%");
		} else if ("like%".equals(operator)) {
			criteria.andLike(target, values[0] + "%");
		} else if ("%notlike".equals(operator)) {
			criteria.andNotLike(target, "%" + values[0]);
		} else if ("%notlike%".equals(operator)) {
			criteria.andNotLike(target, "%" + values[0] + "%");
		} else if ("notlike%".equals(operator)) {
			criteria.andNotLike(target, values[0] + "%");
		} else if ("in".equals(operator)) {
			List<Object> paramList = new ArrayList<Object>();
			for (String val1 : values) {
				for (String val2 : Arrays.asList(val1.split(","))) {
					if (StringUtils.isEmpty(val2)) {
						continue;
					}
					paramList.add(convertDataType(val2, this._schemaColumnCache.getSchemaColumn(columnName)));
				}
			}
			criteria.andIn(target, paramList);
		} else if ("notin".equals(operator)) {
			List<Object> paramList = new ArrayList<Object>();
			for (String val1 : values) {
				for (String val2 : Arrays.asList(val1.split(","))) {
					if (StringUtils.isEmpty(val2)) {
						continue;
					}
					paramList.add(convertDataType(val2, this._schemaColumnCache.getSchemaColumn(columnName)));
				}
			}
			criteria.andNotIn(target, paramList);
		} else if ("between".equals(operator)) {
			if ("from".equals(option)){
				String toKey = resultName + "__cond__" + tableName + "__" + columnName + "__to";
				String[] toValue = this._requestParams.get(toKey);
				if (!StringUtils.isEmpty(values[0]) && !StringUtils.isEmpty(toValue[0])) {
					criteria.andBetween(target,
							convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName)),
							convertDataType(toValue[0], this._schemaColumnCache.getSchemaColumn(columnName)));
				} else if (!StringUtils.isEmpty(values[0])) {
					value = convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName));
					criteria.andGreaterThanOrEqualTo(target, value);
				} else if (!StringUtils.isEmpty(toValue[0])) {
					value = convertDataType(toValue[0], this._schemaColumnCache.getSchemaColumn(columnName));
					criteria.andLessThanOrEqualTo(target, value);
				}
			}
		} else if ("notbetween".equals(operator)) {
			if ("from".equals(option)){
				String toKey = resultName + "__cond__" + tableName + "__" + columnName + "__to";
				String[] toValue = this._requestParams.get(toKey);

				if (!StringUtils.isEmpty(values[0]) && !StringUtils.isEmpty(toValue[0])) {
					criteria.andNotBetween(target,
							convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName)),
							convertDataType(toValue[0], this._schemaColumnCache.getSchemaColumn(columnName)));
				} else if (!StringUtils.isEmpty(values[0])) {
					value = convertDataType(values[0], this._schemaColumnCache.getSchemaColumn(columnName));
					criteria.andLessThan(target, value);
				} else if (!StringUtils.isEmpty(toValue[0])) {
					value = convertDataType(toValue[0], this._schemaColumnCache.getSchemaColumn(columnName));
					criteria.andGreaterThan(target, value);
				}
			}
		} else {
			// TODO:オペレータが不正。WARN出力
		}
	}

	private static String getMapperName(String method, String target) {
		StringBuilder sb = new StringBuilder();
		sb.append(PropertyUtils.getProperty(ControllerConstants.PROPERTY_KEY_ROOT_PACKAGE));
		sb.append('.');
		sb.append(ControllerConstants.MYBATIS_MAPPER_PACKAGE);
		sb.append('.');
		sb.append(snakeToCamel(target, true));
		sb.append(ControllerConstants.MYBATIS_MAPPER_SUFFIX);
		sb.append('.');
		sb.append(CrudEnum.getCrud(method).getStatementId());
		return sb.toString();
	}
}
