/*
 * Copyright 2006-2008 The Wankuma.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.wankuma.mail.helper;

import java.util.Random;

import com.wankuma.commons.lang.Assertion;
import com.wankuma.mail.MessageIdGenerator;

/**
 * シンプルな{@link MessageIdGenerator}の実装です。<br>
 * このジェネレータによって生成されるパターンは以下の通りです。<br>
 * &lt;[ランダムなlong値(絶対値)].[ランダムなlong値(絶対値)].[localPart]@[domainPart]&gt;<br>
 * 例えばlocalPartがjavaでdomainPartがsun.comの場合、&lt;123.456.java@sun.com&gt;となる
 * 
 * @author Katsunori Koyanagi
 * @version 1.0
 */
public class SimpleMessageIdGenerator implements MessageIdGenerator {

	private static Random random = new Random();

	private String domainPart;

	private String localPart;

	/**
	 * 指定のローカルパートのサフィックスとドメインパートでインスタンスを構築します。
	 * 
	 * @param localPart
	 *            ローカルパート
	 * @param domainPart
	 *            ドメインパート
	 * @throws NullPointerException
	 *             localPartもしくはdomainPartが{@code null}の場合
	 */
	public SimpleMessageIdGenerator(String localPart, String domainPart) {
		Assertion.notNull("localPart", localPart);
		Assertion.notNull("domainPart", domainPart);

		this.localPart = localPart;
		this.domainPart = domainPart;
	}

	/**
	 * @see com.wankuma.mail.MessageIdGenerator#getMessageId()
	 */
	@Override
	public String getMessageId() {
		StringBuilder builder = new StringBuilder();
		long long1 = Math.abs(SimpleMessageIdGenerator.random.nextLong());
		long long2 = Math.abs(SimpleMessageIdGenerator.random.nextLong());

		builder.append("<");
		builder.append(long1);
		builder.append(".");
		builder.append(long2);
		builder.append(".");
		builder.append(this.localPart);
		builder.append("@");
		builder.append(this.domainPart);
		builder.append(">");

		return builder.toString();
	}
}
