/*
 * Copyright 2006-2008 The Wankuma.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.wankuma.mail.helper;

import com.wankuma.mail.MailAddress;

/**
 * シンプルな{@link MailAddress}の実装です。
 * 
 * @author Katsunori Koyanagi
 * @version 1.0
 */
public class SimpleMailAddress implements MailAddress {

	private String address;

	private String personal;

	/**
	 * 指定のメールアドレスでインスタンスを構築します。
	 * 
	 * @param address
	 *            メールアドレス
	 * @throws NullPointerException
	 *             addressが{@code null}の場合
	 */
	public SimpleMailAddress(String address) {
		this(address, null);
	}

	/**
	 * 指定のメールアドレスで名前でインスタンスを構築します。<br>
	 * 名前が{@code null}の場合、名前がないものとみなされます。
	 * 
	 * @param address
	 *            メールアドレス
	 * @param personal
	 *            名前
	 * @throws NullPointerException
	 *             addressが{@code null}の場合
	 */
	public SimpleMailAddress(String address, String personal) {
		this.address = address;
		this.personal = personal;
	}

	/**
	 * @see com.wankuma.mail.MailAddress#getAddress()
	 */
	@Override
	public String getAddress() {
		return this.address;
	}

	/**
	 * @see com.wankuma.mail.MailAddress#getPersonal()
	 */
	@Override
	public String getPersonal() {
		return this.personal;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		if (this.personal == null) {
			return this.address;
		}

		return "\"" + this.personal + "\" <" + this.address + ">";
	}
}
