/*
 * Copyright 2006-2008 The Wankuma.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.wankuma.mail.helper;

import com.wankuma.commons.lang.Assertion;
import com.wankuma.mail.Header;

/**
 * シンプルな{@link Header}の実装です。
 * 
 * @author Katsunori Koyanagi
 * @version 1.0
 */
public class SimpleHeader implements Header {

	private String name;

	private String value;

	/**
	 * 指定の名前と値のヘッダを構築します。
	 * 
	 * @param name
	 *            名前
	 * @param value
	 *            値
	 */
	public SimpleHeader(String name, String value) {
		Assertion.notNull("name", name);

		this.name = name;
		this.value = value == null ? "" : value;
	}

	/**
	 * @see com.wankuma.mail.Header#getName()
	 */
	@Override
	public String getName() {
		return this.name;
	}

	/**
	 * @see com.wankuma.mail.Header#getValue()
	 */
	@Override
	public String getValue() {
		return this.value;
	}
}
