/*
 * Copyright 2006-2008 The Wankuma.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.wankuma.mail;

import java.util.Date;

/**
 * 受信メール情報を表現します。
 * 
 * @author Katsunori Koyanagi
 * @version 1.0
 */
public interface ReceivedMailInfo {

	/**
	 * サーバ上からこのメールを削除します。<br>
	 * このメソッドの呼び出しは、通常{@link MailReceiveHandler#doReceive(ReceivedMailInfo)}の中でのみ有効です。<br>
	 * 削除をするためにはセッションが有効である必要があるためです。
	 * 
	 * @throws MailException
	 *             メールの削除に失敗した場合もしくは、このメール情報に関連づいたセッションが既に存在しない場合
	 */
	void delete() throws MailException;

	/**
	 * 送信元のメールアドレスを返します。<br>
	 * 取得できない場合は{@code null}を返し、複数存在する場合は1件のみを返します。
	 * 
	 * @return メールアドレス
	 */
	MailAddress getFrom();

	/**
	 * フォルダに対するメールのインデックスを返します。
	 * 
	 * @return 不明な場合は{@code 0}を返します。
	 */
	int getIndex();

	/**
	 * 受信メールを返します。<br>
	 * このメソッドの呼び出しは、通常{@link MailReceiveHandler#doReceive(ReceivedMailInfo)}の中でのみ有効です。<br>
	 * 受信を行うためにはセッションが有効である必要があるためです。
	 * 
	 * @return 受信メール
	 * 
	 * @throws MailException
	 *             メールの受信に失敗した場合もしくは、このメール情報に関連づいたセッションが既に存在しない場合
	 */
	ReceivedMail getMail();

	/**
	 * 送信日時を返します。<br>
	 * 取得できない場合は{@code null}を返します。
	 * 
	 * @return 送信日時
	 */
	Date getSentDate();

	/**
	 * 件名を返します。<br>
	 * 取得できない場合は{@code null}を返します。
	 * 
	 * @return 件名
	 */
	String getSubject();
}
