/*
 * Copyright 2006-2008 The Wankuma.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.wankuma.mail;

/**
 * 受信メールのReceivedヘッダを表現します。
 * 
 * @author Katsunori Koyanagi
 * @version 1.0
 */
public interface ReceivedHeader extends Header {

	/**
	 * メールを送信したサーバのホストを返します。<br>
	 * 解析に失敗した場合は{@code null}を返します。
	 * 
	 * @return ホスト
	 */
	String getBy();

	/**
	 * メールを受信したサーバのホストを返します。<br>
	 * 解析に失敗した場合は{@code null}を返します。
	 * 
	 * @return ホスト
	 */
	String getFrom();
}
