/*
 * Copyright 2006-2008 The Wankuma.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.wankuma.mail;

/**
 * メールの受信機能を提供します。
 * 
 * @author Katsunori Koyanagi
 * @version 1.0
 */
public interface MailReceiver extends MailService {

	/**
	 * 標準のフォルダ名を示します。
	 */
	String DEFAULT_FOLDER_NAME = "INBOX";

	/**
	 * {@code POP Before SMTP}のための認証処理を行います。<br>
	 * このメソッドは{@link MailService#open(Configuration)}を呼び出した後に、{@link MailService#close()}を呼び出します。
	 * 
	 * @param configuration
	 *            設定
	 * @throws MailException
	 *             接続に失敗した場合
	 */
	void authOnly(Configuration configuration) throws MailException;

	/**
	 * フォルダ名を配列で返します。<br>
	 * 存在しない場合は空の配列を返します。
	 * 
	 * @throws MailException
	 *             フォルダ名の取得に失敗した場合
	 * @return フォルダ名の配列
	 */
	String[] getFolderNames() throws MailException;

	/**
	 * 標準のフォルダのメールの受信を行います。<br>
	 * 受信したメールは指定のハンドラへ渡されます。
	 * 
	 * @param handler
	 *            ハンドラ
	 * @throws MailException
	 *             受信に失敗した場合
	 * @throws NullPointerException
	 *             handlerが{@code null}の場合
	 */
	void receive(MailReceiveHandler handler) throws MailException;

	/**
	 * 指定のフォルダのメールの受信を行います。<br>
	 * 受信したメールは指定のハンドラへ渡されます。
	 * 
	 * @param handler
	 *            ハンドラ
	 * @param folderName
	 *            フォルダ名
	 * @throws MailException
	 *             受信に失敗した場合
	 * @throws NullPointerException
	 *             handlerが{@code null}の場合
	 */
	void receive(MailReceiveHandler handler, String folderName)
			throws MailException;
}
