/*
 * Copyright 2006-2008 The Wankuma.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.wankuma.mail;

import java.io.IOException;
import java.io.InputStream;

/**
 * メール本文を表現します。
 * 
 * @author Katsunori Koyanagi
 * @version 1.0
 */
public interface MailBody {

	/**
	 * コンテントタイプを返します。
	 * 
	 * @return コンテントタイプ
	 */
	String getContentType();

	/**
	 * メール本文のヘッダを配列で返します。<br>
	 * 存在しない場合は空の配列を返します。
	 * 
	 * @return ヘッダの配列
	 */
	Header[] getHeaders();

	/**
	 * メール本文の内容を示す入力ストリームを返します。
	 * 
	 * @return 入力ストリーム
	 * 
	 * @throws IOException
	 *             入力ストリームの取得に失敗した場合
	 */
	InputStream getInputStream() throws IOException;

	/**
	 * 本文をテキストで表現が可能な場合、本文のテキストを返します。<br>
	 * 表現が出来ない場合は空文字列を返します。
	 * 
	 * @return 本文のテキスト
	 */
	String getMessage();
}
