/*
 * Copyright 2006-2008 The Wankuma.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.wankuma.mail;

import java.io.IOException;
import java.io.InputStream;

/**
 * 添付ファイルを表現します。
 * 
 * @author Katsunori Koyanagi
 * @version 1.0
 */
public interface AttachmentFile {

	/**
	 * 添付ファイルの名前を返します。
	 * 
	 * @return 添付ファイル名
	 */
	String getFileName();

	/**
	 * 添付ファイルの内容を入力ストリームとして返します。
	 * 
	 * @return 入力ストリーム
	 * 
	 * @throws IOException
	 *             入力ストリームの取得に失敗した場合
	 */
	InputStream getInputStream() throws IOException;
}
