/*
 * Copyright 2006-2008 The Wankuma.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.wankuma.mail;

import java.net.URL;

import com.wankuma.mail.helper.SimpleAttachmentFile;
import com.wankuma.mail.helper.SimpleMail;
import com.wankuma.mail.helper.SimpleMessageIdGenerator;
import com.wankuma.mail.javamail.JapaneseMailBodyFactory;
import com.wankuma.mail.javamail.JapaneseMailReceiverFactory;
import com.wankuma.mail.javamail.JapaneseMailSenderFactory;

/**
 * テスト
 * 
 * @author Katsunori Koyanagi
 * @version 1.0
 */
public final class Test {

	/**
	 * @param args
	 * @throws Exception
	 */
	public static void main(String[] args) throws Exception {

		System
				.setProperty("sun.nio.cs.map",
						"x-windows-iso2022jp/ISO-2022-JP,x-windows-iso2022jp/ISO-2022-JP");
		Test.pop3();
	}

	@SuppressWarnings("unused")
	private static void pop3() throws Exception {
		MailReceiverFactory factory = new JapaneseMailReceiverFactory();
		MailReceiver receiver = factory.getMailReceiver(
				MailReceiverProtocol.POP3, "localhost");
		Configuration config = new Configuration();
		config.setUser("test");
		config.setPassword("test");

		receiver.open(config);
		for (String name : receiver.getFolderNames()) {
			receiver.receive(new MailReceiveHandler() {
				@Override
				public void doReceive(ReceivedMail mail) {
					// mail.delete();
				}
			}, name);
		}
	}

	@SuppressWarnings("unused")
	private static void smtp() throws Exception {
		MailSenderFactory factory = new JapaneseMailSenderFactory();
		MailBodyFactory bodyFactory = new JapaneseMailBodyFactory();

		MailSender sender = factory.getMailSender("localhost");
		Configuration config = new Configuration();
		config.setDebug(true);
		sender.open(config);

		SimpleMail mail = new SimpleMail();
		mail.addTo("test@yahoo.co.jp", "小,柳2");
		mail.setSubject("～～あああ～～～あああ");
		mail.setFrom("kacchan6@gmail.com", "テ①ト～タロウ");

		mail.addHeader("Message-Id", "hoge@hoge.com");

		MailBody body = bodyFactory.createPlainTextMailBody("<b>こんにちわ～</b>");
		mail.setBody(body);
		mail.setMessageIdGenerator(new SimpleMessageIdGenerator("kacchan6",
				"yahoo.co.jp"));

		mail.addAttachmentFile(new SimpleAttachmentFile(new URL(
				"http://k.yimg.jp/images/top/sp/cgrade/logo.gif")));

		sender.send(mail);
		sender.close();
	}

	private Test() {
	}
}
