/*
 * Copyright 2006-2008 The Wankuma.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.wankuma.mail;

/**
 * メールの送信機能を提供します。
 * 
 * @author Katsunori Koyanagi
 * @version 1.0
 */
public interface MailSender extends MailService {

	/**
	 * 指定のメールの送信を行います。<br>
	 * 空の配列が指定された場合は何も行いません。
	 * 
	 * @param mails
	 *            メールの配列
	 * @throws MailException
	 *             メールの送信に失敗した場合
	 * @throws NullPointerException
	 *             mailsが{@code null}もしくは各要素に{@code null}が含まれる場合
	 */
	void send(Mail... mails) throws MailException;
}
