package jp.sf.wagashi;

import java.util.ArrayList;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class WagashiPlugin extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "jp.sf.wagashi";

	// The shared instance
	private static WagashiPlugin plugin;
	
	private static ArrayList<IEditorListener> fEditorListeners = null;
	/**
	 * The constructor
	 */
	public WagashiPlugin() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static WagashiPlugin getDefault() {
		return plugin;
	}
	
	public static IEditorListener[] getEditorListeners(){
		if(fEditorListeners != null){
			return fEditorListeners.toArray(new IEditorListener[0]);
		}

		fEditorListeners = new ArrayList<IEditorListener>();		
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IExtensionPoint extensionPoint = registry.getExtensionPoint(PLUGIN_ID, "editorListener");
		IExtension[] extensions = extensionPoint.getExtensions();
		for(IExtension extension : extensions){
			IConfigurationElement[] elements = extension.getConfigurationElements();
			for(IConfigurationElement element : elements){
				try{
					Object listener = element.createExecutableExtension("class");
					if(listener instanceof IEditorListener){
						fEditorListeners.add((IEditorListener)listener);
					}
				}
				catch(Exception e){
					System.out.println(e);
				}
			}
		}
		
		return fEditorListeners.toArray(new IEditorListener[0]);
	}
	
	public static void addEditorListener(IEditorListener listener){
		if(fEditorListeners == null){
			getEditorListeners();
		}
		if(!fEditorListeners.contains(listener)){
			fEditorListeners.add(listener);
		}
	}

	public static void removeEditorListener(IEditorListener listener){
		if(fEditorListeners == null){
			return;
		}
		if(fEditorListeners.contains(listener)){
			fEditorListeners.remove(listener);
		}
	}

}
