package jp.sf.wagashi.sakuramochi;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.ui.texteditor.IUpdate;


public class TranslateViewTextAction extends Action implements IUpdate {
	
	private int fOperationCode= -1;
	private ITextOperationTarget fOperationTarget;
	private IAdaptable fTargetProvider;
	
	
	public TranslateViewTextAction(ITextOperationTarget target, int operationCode) {
		super();
		fOperationTarget = target;
		fOperationCode = operationCode;
		update();
	}
		
	public TranslateViewTextAction(IAdaptable targetProvider, int operationCode) {
		super();
		fTargetProvider = targetProvider;
		fOperationCode = operationCode;
		update();
	}
	
	public void run() {
		if (fOperationCode != -1 && fOperationTarget != null)
			fOperationTarget.doOperation(fOperationCode);
	}
	
	public void update() {
		if (fOperationTarget == null && fTargetProvider != null && fOperationCode != -1){
			fOperationTarget= (ITextOperationTarget) fTargetProvider.getAdapter(ITextOperationTarget.class);
		}
	
		boolean isEnabled= (fOperationTarget != null && fOperationTarget.canDoOperation(fOperationCode));
		setEnabled(isEnabled);
	}
}
