package jp.sf.wagashi.sakuramochi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;

import jp.sf.wagashi.sakuramochi.translate.GoogleTranslate;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class TranslatePopupDialog extends PopupDialog {

	private Browser fBrowser;
	//private StyledText fTextWidget;
	private String fSrcText;
	private String fLangFrom;
	private String fLangTo;
	
	private static String fStyleSheet = null;
	private static RGB BG_COLOR_RGB = null;
	
	static{
		Display display = Display.getDefault();
		BG_COLOR_RGB = display.getSystemColor(SWT.COLOR_INFO_BACKGROUND).getRGB();
	}
	
	public TranslatePopupDialog(Shell parent, int shellStyle, boolean takeFocusOnOpen,
			boolean persistBounds, boolean showDialogMenu,
			boolean showPersistAction, String titleText, String infoText) {
		super(parent, shellStyle, takeFocusOnOpen, persistBounds, showDialogMenu, showPersistAction, titleText, infoText);
	}
	
	protected Control createDialogArea(Composite parent) {
		fBrowser = new Browser(parent, SWT.NONE);
		GridData gd= new GridData(GridData.BEGINNING | GridData.FILL_BOTH);
		gd.horizontalIndent= 1;
		gd.verticalIndent= 1;
		fBrowser.setLayoutData(gd);
		fBrowser.addKeyListener(new KeyListener() {

			public void keyPressed(KeyEvent e)  {
				if (e.character == SWT.ESC)
					close();
			}

			public void keyReleased(KeyEvent e) {}
		});
		return fBrowser;
	}
	
	public void setText(String text){
		fBrowser.setText(toHTML(text));
	}
	
	public void setHTML(String html){
		fBrowser.setText(getStyleSheet() + html);
	}

	public void setInfoText(String text){
		super.setInfoText(text);
	}
	
	protected Point getInitialSize() {
		if (!getPersistBounds()) {
			return new Point(300, 180);
		}
		return super.getInitialSize();
	}

	protected Point getInitialLocation(Point initialSize) {
		if (!getPersistBounds()) {
			Point size = getInitialSize();
			Rectangle parentBounds = getParentShell().getBounds();
			int x = parentBounds.x + parentBounds.width / 2 - size.x / 2;
			int y = parentBounds.y + parentBounds.height / 2 - size.y / 2;
			return new Point(x, y);
		}
		return super.getInitialLocation(initialSize);
	}
	
	public void translate(String src, String from, String to){
		fSrcText = src;
		fLangFrom = from;
		fLangTo = to;
		new TranslatorThread().start();
	}
	
	class TranslatorThread extends Thread{
		public void run(){
			String str;
			try{
				str = GoogleTranslate.translate(fSrcText, fLangFrom, fLangTo);
				final String out = toHTML(str);
				getShell().getDisplay().asyncExec(new Runnable(){
					public void run(){
						fBrowser.setText(out);
						setInfoText(TranslateMessages.TranslatePopupDialog_translateComplete);
					}
				});
			}
			catch(Exception e){
				final String out = toHTML(e.toString());
				getShell().getDisplay().asyncExec(new Runnable(){
					public void run(){
						fBrowser.setText(out);
						setInfoText(TranslateMessages.TranslatePopupDialog_translateError);
					}
				});
			}
		}
	}
	
	private static String getStyleSheet(){
		if(fStyleSheet != null){
			return fStyleSheet;
		}
		
		Bundle bundle= Platform.getBundle(JavaPlugin.getPluginId());
		URL styleSheetURL= bundle.getEntry("/JavadocHoverStyleSheet.css"); //$NON-NLS-1$
		if (styleSheetURL != null) {
			try {
				styleSheetURL= FileLocator.toFileURL(styleSheetURL);
				BufferedReader reader= new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
				StringBuffer buffer= new StringBuffer(200);
				String line= reader.readLine();
				while (line != null) {
					buffer.append(line);
					buffer.append('\n');
					line= reader.readLine();
				}
				fStyleSheet = buffer.toString();
			} catch (IOException ex) {
				fStyleSheet = null;
			}
		}
		return fStyleSheet;
	}
	
	private static String toHTML(String text){
		StringBuffer buffer = new StringBuffer();
		
		buffer.append("<html><head><style CHARSET=\"ISO-8859-1\" TYPE=\"text/css\">");
		buffer.append(getStyleSheet());
		buffer.append("</style></head><body text=\"#000000\" bgcolor=\"");
		appendColor(buffer, BG_COLOR_RGB);
		buffer.append("\">");
		buffer.append(text == null ? "" : text);
		buffer.append("</body></html>");
		return buffer.toString();
	}
	
	private static void appendColor(StringBuffer buffer, RGB rgb){
		buffer.append('#');
		buffer.append(Integer.toHexString(rgb.red));
		buffer.append(Integer.toHexString(rgb.green));
		buffer.append(Integer.toHexString(rgb.blue));
	}
}
