package jp.sf.wagashi.sakuramochi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;

public class TranslateLanguageUtil {

	private static HashMap<String,String> fPairMap = new HashMap<String,String>();
	
	static{
		fPairMap.put("ar|en", TranslateMessages.Translation_ar_en);
		fPairMap.put("zh|en", TranslateMessages.Translation_zh_en);
		fPairMap.put("zh-CN|zh-TW", TranslateMessages.Translation_zhCN_zhTW);
		fPairMap.put("zh-TW|zh-CN", TranslateMessages.Translation_zhTW_zhCN);
		fPairMap.put("nl|en", TranslateMessages.Translation_nl_en);
		fPairMap.put("en|ar", TranslateMessages.Translation_en_ar);
		fPairMap.put("en|zh-CN", TranslateMessages.Translation_en_zhCN);
		fPairMap.put("en|zh-TW", TranslateMessages.Translation_en_zhTW);
		fPairMap.put("en|nl", TranslateMessages.Translation_en_nl);
		fPairMap.put("en|fr", TranslateMessages.Translation_en_fr);
		fPairMap.put("en|de", TranslateMessages.Translation_en_de);
		fPairMap.put("en|el", TranslateMessages.Translation_en_el);
		fPairMap.put("en|it", TranslateMessages.Translation_en_it);
		fPairMap.put("en|ja", TranslateMessages.Translation_en_ja);
		fPairMap.put("en|ko", TranslateMessages.Translation_en_ko);
		fPairMap.put("en|pt", TranslateMessages.Translation_en_pt);
		fPairMap.put("en|ru", TranslateMessages.Translation_en_ru);
		fPairMap.put("en|es", TranslateMessages.Translation_en_es);
		fPairMap.put("fr|en", TranslateMessages.Translation_fr_en);
		fPairMap.put("fr|de", TranslateMessages.Translation_fr_de);
		fPairMap.put("de|en", TranslateMessages.Translation_de_en);
		fPairMap.put("de|fr", TranslateMessages.Translation_de_fr);
		fPairMap.put("el|en", TranslateMessages.Translation_el_en);
		fPairMap.put("it|en", TranslateMessages.Translation_it_en);
		fPairMap.put("ja|en", TranslateMessages.Translation_ja_en);
		fPairMap.put("ko|en", TranslateMessages.Translation_ko_en);
		fPairMap.put("pt|en", TranslateMessages.Translation_pt_en);
		fPairMap.put("ru|en", TranslateMessages.Translation_ru_en);
		fPairMap.put("es|en", TranslateMessages.Translation_es_en);
	}
	
	public static String[] getLanguagePairValues(){
		ArrayList<String> pair = new ArrayList<String>();
		pair.addAll(fPairMap.values());
		String[] pairs = pair.toArray(new String[0]);
		return pairs;
	}
	
	public static String[] getSortedLanguagePairValues(){
		String[] pairs = getLanguagePairValues(); 
		Arrays.sort(pairs);
		return pairs;
	}
	
	public static String getPairValue(String key){
		return fPairMap.get(key);
	}

	public static String getPairKey(String value){
		for(String key : fPairMap.keySet()){
			if(value.equals(fPairMap.get(key))){
				return key;
			}
		}
		return null;
	}
}
