package jp.sf.wagashi.anmitsu;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

public class LinePainterPreferenceInitializer extends AbstractPreferenceInitializer{

	public void initializeDefaultPreferences() {
        
        IPreferenceStore store = EditorToolsPlugin.getDefault().getPreferenceStore();
        store.setDefault(EditorToolsConstants.ENABLE_LINE_PAINTER, true);
        
        store.setDefault(EditorToolsConstants.TAB, true);
        store.setDefault(EditorToolsConstants.HALF_SPACE, false);
        store.setDefault(EditorToolsConstants.FULL_SPACE, true);
        store.setDefault(EditorToolsConstants.LINE_FEED, true);
        store.setDefault(EditorToolsConstants.EOF, true);
        store.setDefault(EditorToolsConstants.CUT_SELECTION_TEXT, true);
        
        PreferenceConverter.setDefault(store, EditorToolsConstants.TAB_COLOR, new RGB(160, 160, 160));
        PreferenceConverter.setDefault(store, EditorToolsConstants.HALF_SPACE_COLOR, new RGB(160, 160, 160));
        PreferenceConverter.setDefault(store, EditorToolsConstants.FULL_SPACE_COLOR, new RGB(160, 160, 160));
        PreferenceConverter.setDefault(store, EditorToolsConstants.LINE_FEED_COLOR, new RGB(160, 160, 160));
        PreferenceConverter.setDefault(store, EditorToolsConstants.EOF_COLOR, new RGB(160, 160, 160));
	}
}
