package jp.sf.wagashi.anmitsu;

import java.lang.reflect.Method;

import jp.sf.wagashi.IEditorListener;

import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DragDetectEvent;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class LinePainterListener implements IEditorListener{

	private boolean fBoxSelect = false;
	private Point fBoxSelection = new Point(0, 0);
	
	public void editorOpen(ITextEditor editor) {
		try{
			Method m = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", null);
			m.setAccessible(true);
			ISourceViewer viewer = (ISourceViewer)m.invoke(editor, null);
				
			LinePainter linePainter = new LinePainter(viewer);
			viewer.getTextWidget().addPaintListener(linePainter);
			viewer.getTextWidget().addDisposeListener(linePainter);
			
			viewer.getTextWidget().addKeyListener(new KeyListener(){
				public void keyPressed(KeyEvent e) {
					if(e.keyCode == SWT.ALT){
						fBoxSelect = true;
					}
				}
				public void keyReleased(KeyEvent e) {
					if(e.keyCode == SWT.ALT){
						fBoxSelect = false;
					}
				}
			});
			
			viewer.getTextWidget().addMouseListener(new MouseListener(){
				public void mouseDoubleClick(MouseEvent e) {
				}
				public void mouseDown(MouseEvent e) {
					StyledText text = (StyledText)e.getSource();
					fBoxSelection.x = text.getSelection().x;
					
					//System.out.println("mouseDown:" + fBoxSelect);
				};
				public void mouseUp(MouseEvent e) {
					//System.out.println("mouseUp:" + fBoxSelect);
				}
			});
			
			viewer.getTextWidget().addMouseMoveListener(new MouseMoveListener(){
				public void mouseMove(MouseEvent e) {
					try{
					if(fBoxSelect){
						StyledText text = (StyledText)e.getSource();
						text.setSelection(text.getCaretOffset());
						
						Point p1 = text.getLocationAtOffset(fBoxSelection.x);
						Point p2 = text.getLocationAtOffset(text.getCaretOffset());
						Rectangle r = new Rectangle(
							Math.min(p1.x, p2.x), Math.min(p1.y, p2.y),
							Math.max(p1.x, p2.x), Math.max(p1.y, p2.y)
						);
						System.out.println(r);
						System.out.println(r.y + "," + r.height);
						for(int y = r.y; y <= r.height; y += text.getLineHeight()){
							System.out.println("y=" + y);
							p2.x = r.x;
							p2.y = y;
							p1.x = text.getOffsetAtLocation(p2);
							p2.x = r.width;
							p2.y = y;
							System.out.println("text.getOffsetAtLocation:" + p2);
							p1.y = text.getOffsetAtLocation(p2);
							System.out.println(p1 + "," + p2);
							for(int offset = p2.x; offset < p2.y; offset++){
								//System.out.println(text.getText(offset, offset + 1));
								//System.out.println(offset);
							}
							//System.out.println("\n");
							System.out.println("loop:" + y + "," + r.height);
						}
						System.out.println("\n");
						
						//System.out.println(p1.y + "," + p2.y + text.getLineHeight());
						//System.out.println("mouseMove");
					}
					}
					catch(Exception f){
						f.printStackTrace();
					}
					
				}
			});
			
			//LinePainter linePainter = new LinePainter(viewer);
			//((ITextViewerExtension2)viewer).addPainter(linePainter);
			
			if(SWT.getVersion() > 3300){
				viewer.getTextWidget().addDragDetectListener(new DragDetectListener(){
					public void dragDetected(DragDetectEvent e) {
						if(e.getSource() instanceof StyledText){
							StyledText textWidget = (StyledText)e.getSource();
							int offset = textWidget.getCaretOffset();
							Event event = new Event();
							Point p = textWidget.getLocationAtOffset(offset);
							event.display = textWidget.getDisplay();
							event.x = p.x;
							event.y = p.y;
							event.count = 1;
							textWidget.notifyListeners(SWT.MouseDown, event);
						}
					}
				});
			}
			
		}
		catch(Exception e){
			System.out.println(e);
		}

	}

	public void editorClose(ITextEditor editor) {
	}

	
}
