package jp.sf.wagashi.sakuramochi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditorPreferenceConstants;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class TranslatePreferencePage extends PreferencePage implements IWorkbenchPreferencePage{

	private Combo fTranslationCombo;

	private OverlayPreferenceStore fOverlayStore;
	
	
	public void init(IWorkbench workbench) {
		fOverlayStore = createOverlayStore();
		fOverlayStore.load();
	}

	private OverlayPreferenceStore createOverlayStore() {

		ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
		overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, TranslateConstants.TRANSLATE_PAIR));

		OverlayPreferenceStore.OverlayKey[] keys= new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
		overlayKeys.toArray(keys);
		return new OverlayPreferenceStore(TranslatePlugin.getDefault().getPreferenceStore(), keys);
	}

	private void addLabel(Composite parent, String label){
		Label l= new Label(parent, SWT.LEFT);
		l.setText(label);
		GridData gd = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		l.setLayoutData(gd);
	}
	
	
	protected Control createContents(Composite parent) {
		Composite appearanceComposite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		GridData gd = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		appearanceComposite.setLayoutData(gd);
		appearanceComposite.setLayout(layout);
		addLabel(appearanceComposite, TranslateMessages.TranslatePreferencePage_selectLanguage);

		fTranslationCombo = new Combo(appearanceComposite, SWT.READ_ONLY | SWT.SINGLE);
		for (String value : TranslateLanguageUtil.getSortedLanguagePairValues()) {
			fTranslationCombo.add(value);
		}
		fTranslationCombo.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent e) {
				int index = fTranslationCombo.getSelectionIndex();
				String value = fTranslationCombo.getItem(index);
				String key = TranslateLanguageUtil.getPairKey(value);
				fOverlayStore.setValue(TranslateConstants.TRANSLATE_PAIR, key);
			}

			public void widgetDefaultSelected(SelectionEvent e) {
			}
		});
		fTranslationCombo.setVisibleItemCount(10);
		gd = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		gd.grabExcessHorizontalSpace = true;
		fTranslationCombo.setLayoutData(gd);

		loadValue();
		return appearanceComposite;
	}
	
	public boolean performOk() {
		fOverlayStore.propagate();
    	return true;
    }

   protected void performDefaults() {
	   super.performDefaults();
	   fOverlayStore.loadDefaults();
	   loadValue();
   }
   
   private void loadValue() {
		String key = fOverlayStore.getString(TranslateConstants.TRANSLATE_PAIR);
		String value = TranslateLanguageUtil.getPairValue(key);
		for (int i = 0; i < fTranslationCombo.getItemCount(); i++) {
			if (fTranslationCombo.getItem(i).equals(value)) {
				fTranslationCombo.select(i);
				break;
			}
		}
   }
   
}
