package jp.sf.wagashi.sakuramochi;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

import com.google.api.translate.Language;

public class TranslateHandler extends AbstractHandler{

	public Object execute(ExecutionEvent evnt) throws ExecutionException {
		IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		if(window == null){
			return null;
		}
		IEditorPart editor = window.getActivePage().getActiveEditor();
		if(editor == null){
			return null;
		}

		ISelectionProvider p = ((ITextEditor)editor).getSelectionProvider();
		ISelection selection = p.getSelection();
		String src = ((ITextSelection)selection).getText();
		if(src == null || src.length() == 0){
			return null;
		}
		
		TranslatePopupDialog translateDialog = new TranslatePopupDialog(window.getShell(), SWT.RESIZE | SWT.TOOL, true, false, false, false, null, null);
		translateDialog.create();
		translateDialog.setText(src);
		translateDialog.open();
		translateDialog.translate(src, Language.ENGLISH, Language.JAPANESE);
		return null;
	}
}
