package jp.sf.wagashi.sakuramochi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;

import jp.sf.wagashi.IEditorListener;
import jp.sf.wagashi.WagashiPlugin;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.Bundle;

import com.google.api.translate.Language;

public class TranslateAction implements IEditorActionDelegate, IEditorListener{
	
	private IPreferenceStore fStore;
	private String fLangFrom;
	private String fLangTo;
	
	public TranslateAction(){
		fStore = TranslatePlugin.getDefault().getPreferenceStore();
		fStore.addPropertyChangeListener(new IPropertyChangeListener(){
			public void propertyChange(PropertyChangeEvent event) {
				loadPreference();
			}
		});
		loadPreference();
	}
	
	
	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
	}

	public void run(IAction action) {
		IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		String src = getSelectionText();
		if(src == null || src.length() == 0){
			return;
		}
		
		TranslatePopupDialog translateDialog = new TranslatePopupDialog(window.getShell(), SWT.RESIZE | SWT.TOOL, true, false, false, false, null, null);
		translateDialog.setInfoText(TranslateMessages.TranslatePopupDialog_translating);
		translateDialog.create();
		translateDialog.setText(src);
		translateDialog.open();
		translateDialog.translate(src, fLangFrom, fLangTo);
		
	}

	public void selectionChanged(IAction action, ISelection selection) {
		String selectionText = getSelectionText();
		action.setEnabled(selectionText != null && selectionText.length() > 0 ? true : false);
		
	}
	
	private String getSelectionText(){
		try{
			IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
			ISelection textSelection = editor.getEditorSite().getSelectionProvider().getSelection();
			if(textSelection instanceof ITextSelection){
				String LineFeed = System.getProperty("line.separator");
				String rawString = ((ITextSelection)textSelection).getText();
				StringBuffer sb = new StringBuffer();
				for(String line : rawString.split(LineFeed)){
					line = line.trim();
					if(line.length() > 0){
						sb.append(line).append(LineFeed);
					}
				}
				return sb.toString();
			}
		}catch(Exception e){}
		return null;
	}
	
	private void loadPreference(){
		String pair = fStore.getString(TranslateConstants.TRANSLATE_PAIR);
		String[] lang = pair.split("\\|");
		fLangFrom = lang[0];
		fLangTo = lang[1];
	}
	
	public void editorOpen(ITextEditor editor) {
		WagashiPlugin.removeEditorListener(this);
	}
	
	public void editorClose(ITextEditor editor) {
	}
}
