package jp.sf.wagashi.anmitsu;

import java.lang.reflect.Method;

import jp.sf.wagashi.IEditorListener;

import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DragDetectEvent;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class LinePainterListener implements IEditorListener{

	public void editorOpen(ITextEditor editor) {
		try{
			Method m = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", null);
			m.setAccessible(true);
			ISourceViewer viewer = (ISourceViewer)m.invoke(editor, null);
				
			viewer.getTextWidget().addPaintListener(new LinePainter(viewer));
			//LinePainter linePainter = new LinePainter(viewer);
			//((ITextViewerExtension2)viewer).addPainter(linePainter);
			
			viewer.getTextWidget().addDragDetectListener(new DragDetectListener(){
				public void dragDetected(DragDetectEvent e) {
					if(e.getSource() instanceof StyledText){
						StyledText textWidget = (StyledText)e.getSource();
						int offset = textWidget.getCaretOffset();
						Event event = new Event();
						Point p = textWidget.getLocationAtOffset(offset);
						event.display = textWidget.getDisplay();
						event.x = p.x;
						event.y = p.y;
						event.count = 1;
						textWidget.notifyListeners(SWT.MouseDown, event);
					}
				}
			});
			
		}
		catch(Exception e){}

	}

	public void editorClose(ITextEditor editor) {
	}

	
}
