/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.translate;

import com.google.api.translate.Language;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

public class Translate {
    private static final String ENCODING = "UTF-8";
    private static final String INTERMEDIATE_LANGUAGE = "en";
    private static final String URL_STRING = "http://translate.google.com/translate_t?langpair=";
    private static final String TEXT_VAR = "&text=";
    private static final int RATE_DELAY = 2000;
    private static boolean rateControl = true;
    private static long lastQueryTime = 0L;

    public static boolean isUsingRateControl() {
        return rateControl;
    }

    public static void setUsingRateControl(boolean rateControl) {
        Translate.rateControl = rateControl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String toString(InputStream inputStream) throws Exception {
        block6: {
            outputBuilder = new StringBuilder();
            try {
                while (true) {
                    block7: {
                        if (Translate.rateControl && Translate.lastQueryTime + 2000L > System.currentTimeMillis()) break block7;
                        if (inputStream == null) break block6;
                        reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                        if (true) ** GOTO lbl20
                    }
                    try {
                        Thread.sleep(Translate.lastQueryTime + 2000L - System.currentTimeMillis());
                    }
                    catch (InterruptedException e) {
                        System.out.println("[google-api-translate-java] Interrupted sleep.");
                    }
                }
            }
            catch (Exception ex) {
                throw new Exception("[google-api-translate-java] Error reading translation stream.", ex);
            }
            do {
                outputBuilder.append(string).append('\n');
lbl20:
                // 2 sources

            } while ((string = reader.readLine()) != null);
        }
        if (Translate.rateControl == false) return outputBuilder.toString();
        Translate.lastQueryTime = System.currentTimeMillis();
        return outputBuilder.toString();
    }

    public static String translate(String text, String from, String to) throws Exception {
        if (Language.isValidLanguagePair(from, to)) {
            return Translate.retrieveTranslation(text, from, to);
        }
        String intermediary = Translate.retrieveTranslation(text, from, INTERMEDIATE_LANGUAGE);
        String result = Translate.retrieveTranslation(intermediary, INTERMEDIATE_LANGUAGE, to);
        return text.equals(intermediary) || intermediary.equals(result) ? text : result;
    }

    private static String retrieveTranslation(String text, String from, String to) throws Exception {
        String string;
        StringBuilder url = new StringBuilder();
        url.append(URL_STRING).append(from).append('|').append(to);
        url.append(TEXT_VAR).append(URLEncoder.encode(text, ENCODING));
        HttpURLConnection uc = (HttpURLConnection)new URL(url.toString()).openConnection();
        try {
            uc.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)");
            String page = Translate.toString(uc.getInputStream());
            int resultBox = page.indexOf("<div id=result_box dir=");
            if (resultBox < 0) {
                throw new Error("No translation result returned.");
            }
            String start = page.substring(resultBox);
            string = start.substring(start.indexOf(62) + 1, start.indexOf("</div>"));
        }
        catch (Throwable throwable) {
            try {
                uc.getInputStream().close();
                if (uc.getErrorStream() != null) {
                    uc.getErrorStream().close();
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new Exception("[google-api-translate-java] Error retrieving translation.", ex);
            }
        }
        uc.getInputStream().close();
        if (uc.getErrorStream() != null) {
            uc.getErrorStream().close();
        }
        return string;
    }
}

