/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.wagashi.anmitsu;

import java.util.ArrayList;
import jp.sf.wagashi.anmitsu.EditorToolsMessages;
import jp.sf.wagashi.anmitsu.EditorToolsPlugin;
import org.eclipse.jdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LinePainterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ArrayList<Control> fControlList = new ArrayList();
    private ArrayList<ColorSelector> fSelectorList = new ArrayList();
    private String[] fAppearanceColorListModel = new String[]{"wagashi.anmitsu_tabColor", "wagashi.anmitsu_halfSpaceColor", "wagashi.anmitsu_fullSpaceColor", "wagashi.anmitsu_lineFeedColor", "wagashi.anmitsu_eofColor"};
    private OverlayPreferenceStore fOverlayStore;

    public void init(IWorkbench workbench) {
        this.fOverlayStore = this.createOverlayStore();
        this.fOverlayStore.load();
    }

    private OverlayPreferenceStore createOverlayStore() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "wagashi.anmitsu.enableLinePainter"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "wagashi.anmitsu_tab"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "wagashi.anmitsu_halfSpace"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "wagashi.anmitsu_fullSpace"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "wagashi.anmitsu_lineFeed"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "wagashi.anmitsu_eof"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "wagashi.anmitsu_cutSelectionText"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "wagashi.anmitsu_tabColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "wagashi.anmitsu_halfSpaceColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "wagashi.anmitsu_fullSpaceColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "wagashi.anmitsu_lineFeedColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "wagashi.anmitsu_eofColor"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(EditorToolsPlugin.getDefault().getPreferenceStore(), keys);
    }

    private Button addCheckBox(Composite parent, String label, final String key) {
        final Button b = new Button(parent, 32);
        b.setText(label);
        b.setData((Object)key);
        b.setSelection(this.fOverlayStore.getBoolean(key));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LinePainterPreferencePage.this.fOverlayStore.setValue(key, b.getSelection());
            }
        });
        GridData gd = new GridData(34);
        gd.horizontalSpan = 2;
        b.setLayoutData((Object)gd);
        this.fControlList.add((Control)b);
        return b;
    }

    private Button addColorButton(Composite parent, final String key) {
        final ColorSelector selector = new ColorSelector(parent);
        Button b = selector.getButton();
        b.setData((Object)key);
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 1;
        b.setLayoutData((Object)gd);
        b.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceConverter.setValue((IPreferenceStore)LinePainterPreferencePage.this.fOverlayStore, (String)key, (RGB)selector.getColorValue());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        selector.setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key));
        this.fSelectorList.add(selector);
        return b;
    }

    private void addLabel(Composite parent, String label) {
        Label l = new Label(parent, 16384);
        l.setText(label);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
    }

    protected Control createContents(Composite parent) {
        ArrayList<Control> slaveList = new ArrayList<Control>();
        Composite appearanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData gd = new GridData(80);
        appearanceComposite.setLayoutData((Object)gd);
        appearanceComposite.setLayout((Layout)layout);
        Button master = this.addCheckBox(appearanceComposite, EditorToolsMessages.LinePainterPreferencePage_enableLinePainter, "wagashi.anmitsu.enableLinePainter");
        Group group = new Group(appearanceComposite, 0);
        group.setText(EditorToolsMessages.LinePainterPreferencePage_group_options);
        layout = new GridLayout();
        layout.numColumns = 1;
        gd = new GridData(16);
        gd.horizontalIndent = 15;
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)layout);
        slaveList.add((Control)this.addCheckBox((Composite)group, EditorToolsMessages.LinePainterPreferencePage_showTab, "wagashi.anmitsu_tab"));
        slaveList.add((Control)this.addCheckBox((Composite)group, EditorToolsMessages.LinePainterPreferencePage_showHalfSpace, "wagashi.anmitsu_halfSpace"));
        slaveList.add((Control)this.addCheckBox((Composite)group, EditorToolsMessages.LinePainterPreferencePage_showFullSpace, "wagashi.anmitsu_fullSpace"));
        slaveList.add((Control)this.addCheckBox((Composite)group, EditorToolsMessages.LinePainterPreferencePage_showLineFeed, "wagashi.anmitsu_lineFeed"));
        slaveList.add((Control)this.addCheckBox((Composite)group, EditorToolsMessages.LinePainterPreferencePage_showEOF, "wagashi.anmitsu_eof"));
        slaveList.add((Control)this.addCheckBox((Composite)group, EditorToolsMessages.LinePainterPreferencePage_cutAtLineFeed, "wagashi.anmitsu_cutSelectionText"));
        group = new Group(appearanceComposite, 0);
        group.setText(EditorToolsMessages.LinePainterPreferencePage_group_colors);
        layout = new GridLayout();
        layout.numColumns = 3;
        gd = new GridData(16);
        gd.horizontalIndent = 15;
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)layout);
        this.addLabel((Composite)group, EditorToolsMessages.LinePainterPreferencePage_tabColor);
        slaveList.add((Control)this.addColorButton((Composite)group, "wagashi.anmitsu_tabColor"));
        this.addLabel((Composite)group, EditorToolsMessages.LinePainterPreferencePage_halfSpaceColor);
        slaveList.add((Control)this.addColorButton((Composite)group, "wagashi.anmitsu_halfSpaceColor"));
        this.addLabel((Composite)group, EditorToolsMessages.LinePainterPreferencePage_fullSpaceColor);
        slaveList.add((Control)this.addColorButton((Composite)group, "wagashi.anmitsu_fullSpaceColor"));
        this.addLabel((Composite)group, EditorToolsMessages.LinePainterPreferencePage_lineFeedColor);
        slaveList.add((Control)this.addColorButton((Composite)group, "wagashi.anmitsu_lineFeedColor"));
        this.addLabel((Composite)group, EditorToolsMessages.LinePainterPreferencePage_EOFColor);
        slaveList.add((Control)this.addColorButton((Composite)group, "wagashi.anmitsu_eofColor"));
        this.createDependency(master, slaveList);
        return appearanceComposite;
    }

    private void createDependency(final Button master, final ArrayList<Control> slaveList) {
        master.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LinePainterPreferencePage.this.setDependencyEnabled(master, slaveList);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setDependencyEnabled(master, slaveList);
    }

    private void setDependencyEnabled(Button master, ArrayList<Control> slaveList) {
        boolean b = master.getSelection();
        for (Control c : slaveList) {
            c.setEnabled(b);
        }
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.fOverlayStore.loadDefaults();
        for (Control control : this.fControlList) {
            if (!(control instanceof Button)) continue;
            ((Button)control).setSelection(this.fOverlayStore.getBoolean(control.getData().toString()));
        }
        for (ColorSelector colorSelector : this.fSelectorList) {
            colorSelector.setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)colorSelector.getButton().getData().toString()));
        }
    }
}

