/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.wagashi.anmitsu;

import java.util.HashMap;
import jp.sf.wagashi.anmitsu.EditorToolsPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.texteditor.PropertyEventDispatcher;

public class LinePainter
implements IPainter,
PaintListener {
    private boolean fIsActive = false;
    private ITextViewer fTextViewer;
    private StyledText fTextWidget;
    private boolean fIsAdvancedGraphicsPresent;
    private boolean fShowHighlightCurrentLine;
    private boolean fEnableLinePainter;
    private boolean fShowTab;
    private boolean fShowHalfSpace;
    private boolean fShowFullSpace;
    private boolean fShowLineFeed;
    private boolean fShowEOF;
    private boolean fIsCutSelectionText;
    private Color fTabColor;
    private Color fHalfSpaceColor;
    private Color fFullSpaceColor;
    private Color fLineFeedColor;
    private Color fEOFColor;
    private Color fHighlightCurrentColor;
    private PropertyEventDispatcher fEditorDispatcher = null;
    private PropertyEventDispatcher fLinePainterDispatcher = null;
    private HashMap<String, Color> fColorMap = new HashMap();

    public LinePainter(ITextViewer textViewer) {
        this.fTextViewer = textViewer;
        this.fTextWidget = textViewer.getTextWidget();
        this.propertyChange();
        this.addPropertyEventDispatcher();
    }

    private void addPropertyEventDispatcher() {
        final IPreferenceStore store = EditorToolsPlugin.getDefault().getPreferenceStore();
        this.fLinePainterDispatcher = new PropertyEventDispatcher(store);
        this.fLinePainterDispatcher.addPropertyChangeListener("wagashi.anmitsu.enableLinePainter", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LinePainter.this.fEnableLinePainter = (Boolean)event.getNewValue();
                LinePainter.this.fTextWidget.redraw();
            }
        });
        this.fLinePainterDispatcher.addPropertyChangeListener("wagashi.anmitsu_tab", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LinePainter.this.fShowTab = (Boolean)event.getNewValue();
                LinePainter.this.fTextWidget.redraw();
            }
        });
        this.fLinePainterDispatcher.addPropertyChangeListener("wagashi.anmitsu_halfSpace", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LinePainter.this.fShowHalfSpace = (Boolean)event.getNewValue();
                LinePainter.this.fTextWidget.redraw();
            }
        });
        this.fLinePainterDispatcher.addPropertyChangeListener("wagashi.anmitsu_fullSpace", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LinePainter.this.fShowFullSpace = (Boolean)event.getNewValue();
                LinePainter.this.fTextWidget.redraw();
            }
        });
        this.fLinePainterDispatcher.addPropertyChangeListener("wagashi.anmitsu_lineFeed", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LinePainter.this.fShowLineFeed = (Boolean)event.getNewValue();
                LinePainter.this.fTextWidget.redraw();
            }
        });
        this.fLinePainterDispatcher.addPropertyChangeListener("wagashi.anmitsu_eof", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LinePainter.this.fShowEOF = (Boolean)event.getNewValue();
                LinePainter.this.fTextWidget.redraw();
            }
        });
        this.fLinePainterDispatcher.addPropertyChangeListener("wagashi.anmitsu_cutSelectionText", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LinePainter.this.fIsCutSelectionText = (Boolean)event.getNewValue();
                LinePainter.this.fTextWidget.redraw();
            }
        });
        this.fLinePainterDispatcher.addPropertyChangeListener("wagashi.anmitsu_tabColor", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LinePainter.this.fTabColor = new Color((Device)LinePainter.this.fTextWidget.getDisplay(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"wagashi.anmitsu_tabColor"));
                LinePainter.this.fColorMap.put("wagashi.anmitsu_tabColor", LinePainter.this.fTabColor);
                LinePainter.this.fTextWidget.redraw();
            }
        });
        this.fLinePainterDispatcher.addPropertyChangeListener("wagashi.anmitsu_halfSpaceColor", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LinePainter.this.fHalfSpaceColor = new Color((Device)LinePainter.this.fTextWidget.getDisplay(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"wagashi.anmitsu_halfSpaceColor"));
                LinePainter.this.fTextWidget.redraw();
            }
        });
        this.fLinePainterDispatcher.addPropertyChangeListener("wagashi.anmitsu_fullSpaceColor", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LinePainter.this.fFullSpaceColor = new Color((Device)LinePainter.this.fTextWidget.getDisplay(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"wagashi.anmitsu_fullSpaceColor"));
                LinePainter.this.fTextWidget.redraw();
            }
        });
        this.fLinePainterDispatcher.addPropertyChangeListener("wagashi.anmitsu_lineFeedColor", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LinePainter.this.fLineFeedColor = new Color((Device)LinePainter.this.fTextWidget.getDisplay(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"wagashi.anmitsu_lineFeedColor"));
                LinePainter.this.fTextWidget.redraw();
            }
        });
        this.fLinePainterDispatcher.addPropertyChangeListener("wagashi.anmitsu_eofColor", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LinePainter.this.fEOFColor = new Color((Device)LinePainter.this.fTextWidget.getDisplay(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"wagashi.anmitsu_eofColor"));
                LinePainter.this.fTextWidget.redraw();
            }
        });
        final IPreferenceStore editorStore = EditorsPlugin.getDefault().getPreferenceStore();
        this.fEditorDispatcher = new PropertyEventDispatcher(editorStore);
        this.fEditorDispatcher.addPropertyChangeListener("currentLine", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LinePainter.this.fShowHighlightCurrentLine = (Boolean)event.getNewValue();
            }
        });
        this.fEditorDispatcher.addPropertyChangeListener("currentLineColor", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LinePainter.this.fHighlightCurrentColor = new Color((Device)LinePainter.this.fTextWidget.getDisplay(), PreferenceConverter.getColor((IPreferenceStore)editorStore, (String)"currentLineColor"));
            }
        });
    }

    public void dispose() {
        if (this.fEditorDispatcher != null) {
            this.fEditorDispatcher.dispose();
            this.fEditorDispatcher = null;
        }
        if (this.fLinePainterDispatcher != null) {
            this.fLinePainterDispatcher.dispose();
            this.fLinePainterDispatcher = null;
        }
        this.fTabColor = null;
        this.fHalfSpaceColor = null;
        this.fFullSpaceColor = null;
        this.fLineFeedColor = null;
        this.fEOFColor = null;
        this.fHighlightCurrentColor = null;
        this.fTextViewer = null;
        this.fTextWidget = null;
    }

    public void paint(int reason) {
        block9: {
            if (!this.fEnableLinePainter) {
                return;
            }
            try {
                IDocument document = this.fTextViewer.getDocument();
                if (document == null) {
                    this.deactivate(false);
                    return;
                }
                if (!this.fIsActive) {
                    this.fIsActive = true;
                    this.fTextWidget.addPaintListener((PaintListener)this);
                    this.fTextWidget.redraw();
                    break block9;
                }
                if (reason == 16 || reason == 8) {
                    this.fTextWidget.redraw();
                    break block9;
                }
                if (reason != 1) break block9;
                try {
                    IRegion lineRegion = document.getLineInformationOfOffset(this.getDocumentOffset(this.fTextWidget.getCaretOffset()));
                    int widgetOffset = this.getWidgetOffset(lineRegion.getOffset());
                    int charCount = this.fTextWidget.getCharCount();
                    int redrawLength = Math.min(lineRegion.getLength(), charCount - widgetOffset);
                    if (widgetOffset >= 0 && redrawLength > 0) {
                        this.fTextWidget.redrawRange(widgetOffset, redrawLength, true);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public void deactivate(boolean redraw) {
        if (this.fIsActive) {
            this.fIsActive = false;
            this.fTextWidget.removePaintListener((PaintListener)this);
            if (redraw) {
                this.fTextWidget.redraw();
            }
        }
    }

    public void setPositionManager(IPaintPositionManager manager) {
    }

    public void paintControl(PaintEvent event) {
        if (this.fTextWidget != null && this.fEnableLinePainter) {
            this.handleDrawRequest(event.gc, event.x, event.y, event.width, event.height);
        }
    }

    private void handleDrawRequest(GC gc, int x, int y, int w, int h) {
        int endLine;
        int lineCount = this.fTextWidget.getLineCount();
        int startLine = (y + this.fTextWidget.getTopPixel()) / this.fTextWidget.getLineHeight();
        if (startLine <= (endLine = (y + h - 1 + this.fTextWidget.getTopPixel()) / this.fTextWidget.getLineHeight()) && startLine < lineCount) {
            int endOffset;
            int startOffset = this.fTextWidget.getOffsetAtLine(startLine);
            int n = endOffset = endLine < lineCount - 1 ? this.fTextWidget.getOffsetAtLine(endLine + 1) : this.fTextWidget.getCharCount();
            if (this.fIsAdvancedGraphicsPresent) {
                int alpha = gc.getAlpha();
                gc.setAlpha(255);
                this.handleDrawRequest(gc, startOffset, endOffset);
                gc.setAlpha(alpha);
            } else {
                this.handleDrawRequest(gc, startOffset, endOffset);
            }
        }
    }

    private void handleDrawRequest(GC gc, int startOffset, int endOffset) {
        StyledTextContent content = this.fTextWidget.getContent();
        int length = endOffset - startOffset;
        String text = content.getTextRange(startOffset, length);
        int textOffset = 0;
        while (textOffset <= length) {
            if (textOffset < length) {
                char c = text.charAt(textOffset);
                switch (c) {
                    case ' ': {
                        this.drawHalfSpace(gc, startOffset + textOffset);
                        break;
                    }
                    case '\u3000': {
                        this.drawFullSpace(gc, startOffset + textOffset);
                        break;
                    }
                    case '\t': {
                        this.drawTab(gc, startOffset + textOffset);
                        break;
                    }
                    case '\n': {
                        this.drawLineFeed(gc, startOffset + textOffset);
                        break;
                    }
                }
            }
            ++textOffset;
        }
        if (content.getLineAtOffset(endOffset) == content.getLineCount() - 1) {
            this.drawEOF(gc, endOffset);
        }
    }

    private boolean isFoldedLine(int widgetLine) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
            int modelLine = extension.widgetLine2ModelLine(widgetLine);
            int widgetLine2 = extension.modelLine2WidgetLine(modelLine + 1);
            return widgetLine2 == -1;
        }
        return false;
    }

    private void drawHalfSpace(GC gc, int offset) {
        StyledTextContent content = this.fTextWidget.getContent();
        if (!this.isFoldedLine(content.getLineAtOffset(offset))) {
            Color[] color = this.getColors(offset, "wagashi.anmitsu_halfSpaceColor");
            Point pos = this.fTextWidget.getLocationAtOffset(offset);
            Point pos2 = this.fTextWidget.getLocationAtOffset(offset + 1);
            gc.setForeground(color[0]);
            gc.setBackground(color[1]);
            int charWidth = pos2.x - pos.x;
            int count = charWidth >= 7 ? 3 : charWidth - 1 >> 1;
            int startx = charWidth >= 7 ? charWidth - 7 >> 1 : 0;
            int height = this.fTextWidget.getLineHeight() - 1;
            gc.fillRectangle(pos.x, pos.y, pos2.x - pos.x, this.fTextWidget.getLineHeight());
            if (this.fShowHalfSpace) {
                gc.drawPoint(pos.x + startx, pos.y + height - 2);
                gc.drawPoint(pos.x + startx, pos.y + height - 4);
                gc.drawPoint((count << 1) + pos.x + startx, pos.y + height - 2);
                gc.drawPoint((count << 1) + pos.x + startx, pos.y + height - 4);
                int i = 0;
                while (i < count) {
                    gc.drawPoint(pos.x + startx + 1 + (i << 1), pos.y + height - 1);
                    ++i;
                }
            }
        }
    }

    private void drawFullSpace(GC gc, int offset) {
        StyledTextContent content = this.fTextWidget.getContent();
        if (!this.isFoldedLine(content.getLineAtOffset(offset))) {
            Color[] color = this.getColors(offset, "wagashi.anmitsu_fullSpaceColor");
            Point pos = this.fTextWidget.getLocationAtOffset(offset);
            Point pos2 = this.fTextWidget.getLocationAtOffset(offset + 1);
            gc.setForeground(color[0]);
            gc.setBackground(color[1]);
            int charWidth = pos2.x - pos.x;
            int startx = (charWidth >> 1) - 4;
            int starty = (this.fTextWidget.getLineHeight() >> 1) - 4;
            gc.fillRectangle(pos.x, pos.y, pos2.x - pos.x, this.fTextWidget.getLineHeight());
            if (this.fShowFullSpace) {
                int i = 0;
                while (i < 4) {
                    gc.drawPoint(pos.x + startx, 2 + pos.y + starty + (i << 1));
                    gc.drawPoint(pos.x + startx + 8, 2 + pos.y + starty + (i << 1));
                    ++i;
                }
                i = 0;
                while (i < 4) {
                    gc.drawPoint(1 + pos.x + startx + (i << 1), 1 + pos.y + starty);
                    gc.drawPoint(1 + pos.x + startx + (i << 1), 9 + pos.y + starty);
                    ++i;
                }
            }
        }
    }

    private void drawTab(GC gc, int offset) {
        StyledTextContent content = this.fTextWidget.getContent();
        if (!this.isFoldedLine(content.getLineAtOffset(offset))) {
            int height = this.fTextWidget.getLineHeight() >> 1;
            Color[] color = this.getColors(offset, "wagashi.anmitsu_tabColor");
            Point pos = this.fTextWidget.getLocationAtOffset(offset);
            Point pos2 = this.fTextWidget.getLocationAtOffset(offset + 1);
            gc.setForeground(color[0]);
            gc.setBackground(color[1]);
            gc.fillRectangle(pos.x, pos.y, pos2.x - pos.x, this.fTextWidget.getLineHeight());
            if (this.fShowTab) {
                gc.drawPoint(pos.x + 1, pos.y + height - 1);
                gc.drawPoint(pos.x + 1, pos.y + height + 1);
                gc.drawPoint(pos.x + 2, pos.y + height);
                gc.drawPoint(pos.x + 3, pos.y + height);
            }
        }
    }

    private void drawLineFeed(GC gc, int offset) {
        FontMetrics fontMetrics = gc.getFontMetrics();
        int width = this.fTextWidget.getBounds().width;
        int lineFeedWidth = 9;
        Point pos = this.fTextWidget.getLocationAtOffset(offset);
        StyledTextContent content = this.fTextWidget.getContent();
        if (!this.isFoldedLine(content.getLineAtOffset(offset))) {
            int fontBaseline = this.fTextWidget.getLineHeight() - fontMetrics.getDescent() - 1;
            Color[] color = this.getLineFeedColors(offset);
            gc.setForeground(color[0]);
            gc.setBackground(color[1]);
            if (this.fIsCutSelectionText) {
                gc.fillRectangle(pos.x + lineFeedWidth, pos.y, width - (pos.x + lineFeedWidth), this.fTextWidget.getLineHeight());
                if (color[2] != null) {
                    gc.setBackground(color[2]);
                }
                gc.fillRectangle(pos.x, pos.y, lineFeedWidth, this.fTextWidget.getLineHeight());
            }
            if (this.fShowLineFeed) {
                gc.drawPoint(pos.x + 1, pos.y + fontBaseline);
                gc.drawLine(pos.x + 2, pos.y + fontBaseline - 1, pos.x + 2, pos.y + fontBaseline + 1);
                gc.drawLine(pos.x + 3, pos.y + fontBaseline - 2, pos.x + 3, pos.y + fontBaseline + 2);
                gc.drawLine(pos.x + 4, pos.y + fontBaseline, pos.x + 5, pos.y + fontBaseline);
                gc.drawLine(pos.x + 6, pos.y + fontBaseline - 1, pos.x + 6, pos.y + fontBaseline - 6);
            }
        }
    }

    private void drawEOF(GC gc, int offset) {
        int width = this.fTextWidget.getBounds().width;
        Point pos = this.fTextWidget.getLocationAtOffset(offset);
        Color bg = this.fTextWidget.getLineAtOffset(offset) == this.fTextWidget.getLineAtOffset(this.fTextWidget.getCaretOffset()) && this.fShowHighlightCurrentLine ? this.fHighlightCurrentColor : this.fTextWidget.getBackground();
        gc.setForeground(this.fEOFColor);
        gc.setBackground(bg);
        gc.fillRectangle(pos.x, pos.y, width - pos.x, this.fTextWidget.getLineHeight());
        if (this.fShowEOF) {
            gc.drawString("[EOF]", pos.x, pos.y);
        }
    }

    private int getWidgetOffset(int documentOffset) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
            return extension.modelOffset2WidgetOffset(documentOffset);
        }
        IRegion visible = this.fTextViewer.getVisibleRegion();
        int widgetOffset = documentOffset - visible.getOffset();
        if (widgetOffset > visible.getLength()) {
            return -1;
        }
        return widgetOffset;
    }

    private Color[] getColors(int offset, String key) {
        Color[] colors = new Color[2];
        Point selection = this.fTextWidget.getSelection();
        colors[0] = this.fColorMap.get(key);
        colors[1] = offset >= selection.x && offset < selection.y ? this.fTextWidget.getSelectionBackground() : (this.fTextWidget.getLineAtOffset(offset) == this.fTextWidget.getLineAtOffset(this.fTextWidget.getCaretOffset()) && this.fTextWidget.getLineAtOffset(selection.x) == this.fTextWidget.getLineAtOffset(selection.y) && this.fShowHighlightCurrentLine ? this.fHighlightCurrentColor : this.fTextWidget.getBackground());
        return colors;
    }

    private Color[] getLineFeedColors(int offset) {
        Color[] colors = new Color[3];
        Point selection = this.fTextWidget.getSelection();
        if (offset >= selection.x && offset < selection.y) {
            if (this.fIsCutSelectionText) {
                colors[0] = this.fTextWidget.getBackground();
                colors[1] = this.fTextWidget.getBackground();
                colors[2] = this.fLineFeedColor;
            } else {
                colors[0] = this.fLineFeedColor;
                colors[1] = this.fLineFeedColor;
                colors[2] = this.fTextWidget.getBackground();
            }
        } else {
            colors[0] = this.fLineFeedColor;
            colors[1] = this.fTextWidget.getLineAtOffset(offset) == this.fTextWidget.getLineAtOffset(this.fTextWidget.getCaretOffset()) && this.fTextWidget.getLineAtOffset(selection.x) == this.fTextWidget.getLineAtOffset(selection.y) && this.fShowHighlightCurrentLine ? this.fHighlightCurrentColor : this.fTextWidget.getBackground();
        }
        return colors;
    }

    private int getDocumentOffset(int widgetOffset) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
            return extension.widgetOffset2ModelOffset(widgetOffset);
        }
        IRegion visible = this.fTextViewer.getVisibleRegion();
        if (widgetOffset > visible.getLength()) {
            return -1;
        }
        return widgetOffset + visible.getOffset();
    }

    public void propertyChange() {
        Display device = null;
        if (this.fTextWidget != null) {
            device = this.fTextWidget.getDisplay();
        }
        IPreferenceStore store = EditorToolsPlugin.getDefault().getPreferenceStore();
        this.fEnableLinePainter = store.getBoolean("wagashi.anmitsu.enableLinePainter");
        this.fShowTab = store.getBoolean("wagashi.anmitsu_tab");
        this.fShowHalfSpace = store.getBoolean("wagashi.anmitsu_halfSpace");
        this.fShowFullSpace = store.getBoolean("wagashi.anmitsu_fullSpace");
        this.fShowLineFeed = store.getBoolean("wagashi.anmitsu_lineFeed");
        this.fShowEOF = store.getBoolean("wagashi.anmitsu_eof");
        this.fIsCutSelectionText = store.getBoolean("wagashi.anmitsu_cutSelectionText");
        this.fTabColor = new Color((Device)device, PreferenceConverter.getColor((IPreferenceStore)store, (String)"wagashi.anmitsu_tabColor"));
        this.fHalfSpaceColor = new Color((Device)device, PreferenceConverter.getColor((IPreferenceStore)store, (String)"wagashi.anmitsu_halfSpaceColor"));
        this.fFullSpaceColor = new Color((Device)device, PreferenceConverter.getColor((IPreferenceStore)store, (String)"wagashi.anmitsu_fullSpaceColor"));
        this.fLineFeedColor = new Color((Device)device, PreferenceConverter.getColor((IPreferenceStore)store, (String)"wagashi.anmitsu_lineFeedColor"));
        this.fEOFColor = new Color((Device)device, PreferenceConverter.getColor((IPreferenceStore)store, (String)"wagashi.anmitsu_eofColor"));
        this.fColorMap.clear();
        this.fColorMap.put("wagashi.anmitsu_tabColor", this.fTabColor);
        this.fColorMap.put("wagashi.anmitsu_halfSpaceColor", this.fHalfSpaceColor);
        this.fColorMap.put("wagashi.anmitsu_fullSpaceColor", this.fFullSpaceColor);
        this.fColorMap.put("wagashi.anmitsu_lineFeedColor", this.fLineFeedColor);
        this.fColorMap.put("wagashi.anmitsu_eofColor", this.fEOFColor);
        store = EditorsPlugin.getDefault().getPreferenceStore();
        this.fShowHighlightCurrentLine = store.getBoolean("currentLine");
        this.fHighlightCurrentColor = new Color((Device)device, PreferenceConverter.getColor((IPreferenceStore)store, (String)"currentLineColor"));
    }
}

