/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.wagashi.sakuramochi;

import java.util.ArrayList;
import jp.sf.wagashi.sakuramochi.TranslateLanguageUtil;
import jp.sf.wagashi.sakuramochi.TranslateMessages;
import jp.sf.wagashi.sakuramochi.TranslatePlugin;
import org.eclipse.jdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TranslatePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo fTranslationCombo;
    private OverlayPreferenceStore fOverlayStore;

    public void init(IWorkbench workbench) {
        this.fOverlayStore = this.createOverlayStore();
        this.fOverlayStore.load();
    }

    private OverlayPreferenceStore createOverlayStore() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "wagashi.sakuramochi.translatePair"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(TranslatePlugin.getDefault().getPreferenceStore(), keys);
    }

    private void addLabel(Composite parent, String label) {
        Label l = new Label(parent, 16384);
        l.setText(label);
        GridData gd = new GridData(256);
        l.setLayoutData((Object)gd);
    }

    protected Control createContents(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData gd = new GridData(256);
        appearanceComposite.setLayoutData((Object)gd);
        appearanceComposite.setLayout((Layout)layout);
        this.addLabel(appearanceComposite, TranslateMessages.TranslatePreferencePage_selectLanguage);
        this.fTranslationCombo = new Combo(appearanceComposite, 12);
        String[] stringArray = TranslateLanguageUtil.getSortedLanguagePairValues();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            this.fTranslationCombo.add(value);
            ++n2;
        }
        this.fTranslationCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = TranslatePreferencePage.this.fTranslationCombo.getSelectionIndex();
                String value = TranslatePreferencePage.this.fTranslationCombo.getItem(index);
                String key = TranslateLanguageUtil.getPairKey(value);
                TranslatePreferencePage.this.fOverlayStore.setValue("wagashi.sakuramochi.translatePair", key);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fTranslationCombo.setVisibleItemCount(10);
        gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        this.fTranslationCombo.setLayoutData((Object)gd);
        this.loadValue();
        return appearanceComposite;
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.fOverlayStore.loadDefaults();
        this.loadValue();
    }

    private void loadValue() {
        String key = this.fOverlayStore.getString("wagashi.sakuramochi.translatePair");
        String value = TranslateLanguageUtil.getPairValue(key);
        int i = 0;
        while (i < this.fTranslationCombo.getItemCount()) {
            if (this.fTranslationCombo.getItem(i).equals(value)) {
                this.fTranslationCombo.select(i);
                break;
            }
            ++i;
        }
    }
}

