/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.wagashi.sakuramochi;

import jp.sf.wagashi.IEditorListener;
import jp.sf.wagashi.WagashiPlugin;
import jp.sf.wagashi.sakuramochi.TranslateMessages;
import jp.sf.wagashi.sakuramochi.TranslatePlugin;
import jp.sf.wagashi.sakuramochi.TranslatePopupDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class TranslateAction
implements IEditorActionDelegate,
IEditorListener {
    private IPreferenceStore fStore = TranslatePlugin.getDefault().getPreferenceStore();
    private String fLangFrom;
    private String fLangTo;

    public TranslateAction() {
        this.fStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                TranslateAction.this.loadPreference();
            }
        });
        this.loadPreference();
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    public void run(IAction action) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        String src = this.getSelectionText();
        if (src == null || src.length() == 0) {
            return;
        }
        TranslatePopupDialog translateDialog = new TranslatePopupDialog(window.getShell(), 20, true, false, false, false, null, null);
        translateDialog.setInfoText(TranslateMessages.TranslatePopupDialog_translating);
        translateDialog.create();
        translateDialog.setText(src);
        translateDialog.open();
        translateDialog.translate(src, this.fLangFrom, this.fLangTo);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        String selectionText = this.getSelectionText();
        action.setEnabled(selectionText != null && selectionText.length() > 0);
    }

    private String getSelectionText() {
        try {
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            ISelection textSelection = editor.getEditorSite().getSelectionProvider().getSelection();
            if (textSelection instanceof ITextSelection) {
                String LineFeed = System.getProperty("line.separator");
                String rawString = ((ITextSelection)textSelection).getText();
                StringBuffer sb = new StringBuffer();
                String[] stringArray = rawString.split(LineFeed);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if ((line = line.trim()).length() > 0) {
                        sb.append(line).append(LineFeed);
                    }
                    ++n2;
                }
                return sb.toString();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private void loadPreference() {
        String pair = this.fStore.getString("wagashi.sakuramochi.translatePair");
        String[] lang = pair.split("\\|");
        this.fLangFrom = lang[0];
        this.fLangTo = lang[1];
    }

    public void editorOpen(ITextEditor editor) {
        WagashiPlugin.removeEditorListener((IEditorListener)this);
    }

    public void editorClose(ITextEditor editor) {
    }
}

