/*
  ɓ]񂷂
  Satofumi KAMIMURA
  $Id$
*/

#if !MONITOR
#include <runCtrl.h>
#else
#include <mRunCtrl.h>
#endif
#include <vutils.h>
#include <stdio.h>
#include <stdlib.h>

using namespace VXV;


int main(int argc, char *argv[]) {
  try {
#if !MONITOR
    RunCtrl run;
#else
    mRunCtrl run;
    vmonitor::show();
#endif
    if (run.connect(argc, argv) < 0) {
      printf("RunCtrl::connect: %s\n", run.what());
      exit(1);
    }

    // move and stop about (1000, 0)
    VXV::Position target(1000, 0, deg(0));
    run.followLine(target);
    while (run.getLengthToLine(target) < -300) {
      VXV::Delay(100);
    }
    run.stopToLine(target);
    waitStable(run, 100);

    // turn at 90 [deg]
    run.rotateToDirection(deg(90));
    waitStable(run, 100);

    // move and stop about (1000, 1000)
    target = VXV::Position(1000, 1000, deg(90));
    run.followLine(target);
    while (run.getLengthToLine(target) < -300) {
      VXV::Delay(100);
    }
    run.stopToLine(target);
    waitStable(run, 100);

    VXV::Delay(1000);
  } catch (std::exception& e) {
    printf("exception: %s\n", e.what());
  }
  return 0;
}
