/*
  runTicksCtrl.cpp ̃eXg
  Satofumi KAMIMURA
  $Id$
*/

#include "RunTicksCtrlTest.h"

CPPUNIT_TEST_SUITE_REGISTRATION(RunTicksCtrlTest);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(RunTicksCtrlTest, "RunTicksCtrlTest");


void RunTicksCtrlTest::setUp(void) {
  vmonitor::setTimeMagnify(1.0);

  char *argv[] = { "", "--simulator", "--nolog" };
  run = new mRunCtrl();
  int ret_value = run->connect(3, argv);
  CPPUNIT_ASSERT_EQUAL_MESSAGE(run->what(), 0, ret_value);
  CPPUNIT_ASSERT_EQUAL(true, run->isConnected());
}


void RunTicksCtrlTest::tearDown(void) {
  // ؒf
  delete run;
  run = NULL;
}


enum { AdjustOffset = 40, Error = 40 };


void RunTicksCtrlTest::getModuleTicksTest(void) {
  CPPUNIT_ASSERT(run->getModuleTicks() < AdjustOffset + Error);
}


void RunTicksCtrlTest::adjustTicksTest(void) {
  CPPUNIT_ASSERT(run->getModuleTicks() < AdjustOffset + Error);

  vmonitor::setTimeMagnify(128.0);
  VXV::Delay(1000);
  vmonitor::setTimeMagnify(1.0);

  CPPUNIT_ASSERT(run->getModuleTicks() > AdjustOffset + Error);

  run->adjustOwnTicks(0);
  CPPUNIT_ASSERT(run->getModuleTicks() < AdjustOffset + Error);

  run->adjustOwnTicks(1000 * 100);
  CPPUNIT_ASSERT(run->getModuleTicks() >= (1000 * 100));
  CPPUNIT_ASSERT(run->getModuleTicks() < (1000 * 100) + AdjustOffset + Error);
}
