/*
  packetHandleHost.cpp ̃eXg
  Satofumi KAMIMURA
  $Id$
*/

#include "PacketHandleHostTest.h"
#include "packetHandleHost.h"
#include "tRunCtrl.h"
#include "nodeAccess.h"

CPPUNIT_TEST_SUITE_REGISTRATION(PacketHandleHostTest);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(PacketHandleHostTest,
				      "PacketHandleHostTest");

enum {
  SEND_PACKET_SIZE = 256,
};


void PacketHandleHostTest::setUp(void) {
  // ڑ
  char *argv[] = { "", "--simulator", "--nolog" };
  host = new mRunCtrl();
  int ret_value = host->connect(3, argv);
  CPPUNIT_ASSERT_EQUAL_MESSAGE(host->what(), 0, ret_value);
  CPPUNIT_ASSERT(host->con);
  CPPUNIT_ASSERT_EQUAL(true, host->isConnected());
}


void PacketHandleHostTest::tearDown(void) {
  // ؒf
  delete host;
  host = NULL;
}


void PacketHandleHostTest::rawRead(void) {
  runCtrl_t& tbl = host->tbl;
  nodeInfo_t& node = host->node;
  long unique_id = host->unique_id;

  // zXg^[Qbgւ̓ǂݏoeXg
  READ_PACKET_INIT;
  ADD_PACKET_DATA(&pa, tbl.version);
  send_size = terminatePacketInfo(&pa);
  int ret_value = waitPacketResponse(host->con, &tbl,
				     send_packet, send_size, unique_id);
  CPPUNIT_ASSERT_EQUAL(0, ret_value);
}


void PacketHandleHostTest::readTest(void) {
  runCtrl_t& tbl = host->tbl;

  // zXg^[Qbgւ̓ǂݏoeXg
  rawRead();
  CPPUNIT_ASSERT_EQUAL((long)PACKAGE_NUM_VERSION, tbl.version);

  // P
  rawRead();
  CPPUNIT_ASSERT_EQUAL((long)PACKAGE_NUM_VERSION, tbl.version);
}


void PacketHandleHostTest::writeTest(void) {
  char send_packet[SEND_PACKET_SIZE];

  runCtrl_t& tbl = host->tbl;
  nodeInfo_t& node = host->node;
  long unique_id = host->unique_id;

  // zXg^[Qbgւ̏݃eXg
  rawRead();
  CPPUNIT_ASSERT_EQUAL((long)PACKAGE_NUM_VERSION, tbl.version);

  // 
  WRITE_PACKET_INIT;
  ADD_WRITE_PACKET_DATA(&pa, tbl.version, tbl.version + 1);

  int send_size = terminatePacketInfo(&pa);
  int ret_value = waitPacketResponse(host->con, &tbl,
				     send_packet, send_size, unique_id);
  CPPUNIT_ASSERT_EQUAL(0, ret_value);

  // ǂݏo
  rawRead();
  CPPUNIT_ASSERT_EQUAL((long)PACKAGE_NUM_VERSION +1, tbl.version);
}


/*!
  \brief ^[Qbg̓ǂݏoG[̏
  
  \todo 
*/
void PacketHandleHostTest::readErrorTest(void) {

  // ̂...
}


/*!
  \brief ^[Qbgւ̏݉G[̏
  
  \todo 
*/
void PacketHandleHostTest::writeErrorTest(void) {

  // ̂...
}
