/*!
******************************************************************************

	@file	vsun86.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __VSUN86_H__
#define __VSUN86_H__

#include "common.h"

extern const char *vsun86_ver_string;

#include <string.h>

#define SYSCALL_VECTOR		0x20
#define LINT_START_VECTOR	0x28
#define IRQ_START_VECTOR	0x30

#define CACHE_DISABLE		0x80000000
#define NON_CACHED_PTR(p,t)	((t *)((u32)(p) | CACHE_DISABLE))

#define VMM_INT_STACK_SIZE	0x1000
#define VMM_STACK_SIZE		0x10000

EXTERN_C u8 vmm_int_stack[VMM_INT_STACK_SIZE];
EXTERN_C u8 vmm_stack[VMM_STACK_SIZE];

#ifndef _VSUN86_PCSIM
extern void abort( void );
extern u32  virt_to_phys( void * );
#endif	//!_VSUN86_PCSIM

#ifdef	_VSUN86_PCSIM
enum {
	SDL_VSUN86_VIRQ = SDL_USEREVENT,
};
#endif	//_VSUN86_PCSIM

#endif // !__VSUN86_H__
