/*!
******************************************************************************

	@file	vbe.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __VBE_H__
#define __VBE_H__

#define IO_VBE_SEQ		0x03C4
#define IO_VBE_VGAGC	0x03CE

#pragma pack(1)

typedef struct {
	char	id[4];
	u16		version;
	char *	oem_string;
	u8		capabilities[4];
	u16 *	video_mode;
	u16		total_memory;
	u16		revision;
	char *	vendor_name;
	char *	product_name;
	char *	product_rev;
	u8		rsvd[222];
	u8		oem_data[256];
} VBE_CTRL_INFO;

typedef struct {
	union {
		struct {
			u16	supported		: 1;
			u16	rsvd			: 1;
			u16	tty_bios		: 1;
			u16	color			: 1;
			u16	graphics		: 1;
			u16	non_vga			: 1;
			u16	non_vga_mem		: 1;
			u16	linear_fb		: 1;
			u16	double_scan		: 1;
			u16	interlaced		: 1;
			u16	triple_buf		: 1;
			u16	stereoscopic	: 1;
			u16	dual_start_addr	: 1;
		};
		u16	w;
	} mode_attr;
	u8		win_a_attr;
	u8		win_b_attr;
	u16		win_granularity;
	u16		win_size;
	u16		win_a_seg;
	u16		win_b_seg;
	void *	win_func;
	u16		scan_line_bytes;
	u16		x_res;
	u16		y_res;
	u8		x_char_size;
	u8		y_char_size;
	u8		num_planes;
	u8		bpp;
	u8		num_banks;
	u8		mem_model;
	u8		bank_size;
	u8		num_img_pages;
	u8		rsvd1;
	u8		r_mask_size;
	u8		r_field_pos;
	u8		g_mask_size;
	u8		g_field_pos;
	u8		b_mask_size;
	u8		b_field_pos;
	u8		rsvd_mask_size;
	u8		rsvd_field_pos;
	u8		direct_mode_info;
	void *	phys_base;
	u32		off_scr_mem_off;
	u16		off_scr_mem_size;
	u16		lin_line_bytes;
	u8		bnk_img_page_num;
	u8		lin_img_page_num;
	u8		lin_r_mask_size;
	u8		lin_r_field_pos;
	u8		lin_g_mask_size;
	u8		lin_g_field_pos;
	u8		lin_b_mask_size;
	u8		lin_b_field_pos;
	u8		lin_rsvd_mask_size;
	u8		lin_rsvd_field_pos;
	u32		max_pixel_clock;
	u8		rsvd[189];
} VBE_MODE_INFO;

#define VBE_MEM_MODEL_TEXT		0x00
#define VBE_MEM_MODEL_CGA		0x01
#define VBE_MEM_MODEL_HERCULES	0x02
#define VBE_MEM_MODEL_PLANAR	0x03
#define VBE_MEM_MODEL_PACKED	0x04
#define VBE_MEM_MODEL_256COLOR	0x05
#define VBE_MEM_MODEL_DIRECT	0x06
#define VBE_MEM_MODEL_YUV		0x07

#pragma pack()

extern VBE_CTRL_INFO vbe_ctrl_info;
extern VBE_MODE_INFO vbe_mode_info;

extern bool vbe_probe( u16 width, u16 height, u8 bpp );
extern bool vbe_check_status( u16 status );
extern bool vbe_set_disp_start( u32 offset );

#endif // !__VBE_H__
