/*!
******************************************************************************

	@file	msc.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __USB_CLASS_MASS_STORAGE_H__
#define __USB_CLASS_MASS_STORAGE_H__

#pragma pack(1)

// Subclass
#define USB_MSC_SUBCLASS_RBC			0x01
#define USB_MSC_SUBCLASS_SFF_8020i		0x02
#define USB_MSC_SUBCLASS_QIC_157		0x03
#define USB_MSC_SUBCLASS_UFI			0x04
#define USB_MSC_SUBCLASS_SFF_8070i		0x05
#define USB_MSC_SUBCLASS_SCSI			0x06

// Protocol
#define USB_MSC_CBI_WITH_CC_INT			0x00
#define USB_MSC_CBI_WITH_NO_CC_INT		0x01
#define USB_MSC_BULK_ONLY_TRANSPORT		0x50

typedef struct {
	u32		dCBWSignature;
	u32		dCBWTag;
	u32		dCBWDataTransferLength;
	u8		bmCBWFlags;
	u8		bCBWLUN;
	u8		bCBWCBLength;
	u8		CBWCB[16];
} USB_MSC_CBW;

#define USB_MSC_CBW_SIG		0x43425355
#define USB_MSC_CBW_DIR_IN	0x80
#define USB_MSC_CBW_DIR_OUT	0x00

typedef struct {
	u32		dCSWSignature;
	u32		dCSWTag;
	u32		dCSWDataResidue;
	u8		bCSWStatus;
} USB_MSC_CSW;

#define USB_MSC_CSW_SIG		0x53425355

#pragma pack()

extern bool usb_msc_init( USB_DEVICE * );

#endif // ! __USB_CLASS_MASS_STORAGE_H__
