/*!
******************************************************************************

	@file	hid.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __USB_CLASS_HID_H__
#define __USB_CLASS_HID_H__

#include "usb.h"

#pragma pack(1)

#define USB_HID_KEYBOARD		0x01
#define USB_HID_MOUSE			0x02

#define USB_HID_GET_REPORT		0x01
#define USB_HID_GET_IDLE		0x02
#define USB_HID_GET_PROTOCOL	0x03
#define USB_HID_SET_REPORT		0x09
#define USB_HID_SET_IDLE		0x0A
#define USB_HID_SET_PROTOCOL	0x0B

typedef struct {
	u8		bLength;
	u8		bDescriptorType;
	u16		bcdHID;
	u8		bCountryCode;
	u8		bNumDescriptors;
	u8		data[1];
} USB_HID_DESC;

typedef union {
	struct {
		u8		bDescriptorType;
		u16		wDescriptorLength;
		u8		data[1];
	} hdr;
} USB_HID_SUB_DESC;

#define USB_DT_HID				0x2100
#define USB_DT_HID_REPORT		0x2200
#define USB_DT_HID_PHYSICAL		0x2300

#define HID_REPORT_SIZE(b)		((b) & 0x03)
#define HID_REPORT_TAG(b)		((b) & 0xFC)
#define HID_REPORT_TAG_INPUT			0x80
#define HID_REPORT_TAG_OUTPUT			0x90
#define HID_REPORT_TAG_COLLECTION		0xA0
#define HID_REPORT_TAG_FEATURE			0xB0
#define HID_REPORT_TAG_END_COLLECTION	0xC0
#define HID_REPORT_TAG_USAGE_PAGE		0x04
#define HID_REPORT_TAG_LOGICAL_MIN		0x14
#define HID_REPORT_TAG_LOGICAL_MAX		0x24
#define HID_REPORT_TAG_PHYSICAL_MIN		0x34
#define HID_REPORT_TAG_PHYSICAL_MAX		0x44
#define HID_REPORT_TAG_UNIT_EXPONENT	0x54
#define HID_REPORT_TAG_UNIT				0x64
#define HID_REPORT_TAG_REPORT_SIZE		0x74
#define HID_REPORT_TAG_REPORT_ID		0x84
#define HID_REPORT_TAG_REPORT_COUNT		0x94
#define HID_REPORT_TAG_PUSH				0xA4
#define HID_REPORT_TAG_POP				0xB4
#define HID_REPORT_TAG_USAGE			0x08
#define HID_REPORT_TAG_USAGE_MIN		0x18
#define HID_REPORT_TAG_USAGE_MAX		0x28
#define HID_REPORT_TAG_DESIGN_INDEX		0x38
#define HID_REPORT_TAG_DESIGN_MIN		0x48
#define HID_REPORT_TAG_DESIGN_MAX		0x58
#define HID_REPORT_TAG_STRING_INDEX		0x78
#define HID_REPORT_TAG_STRING_MIN		0x88
#define HID_REPORT_TAG_STRING_MAX		0x98
#define HID_REPORT_TAG_DELIMITER		0xA8

#define HID_USAGE_PAGE_GENERAL_DESKTOP	0x01
#define HID_USAGE_PAGE_KEYBOARD			0x07
#define HID_USAGE_PAGE_LED				0x08
#define HID_USAGE_PAGE_BUTTON			0x09

#define HID_USAGE_POINTER				0x01
#define HID_USAGE_MOUSE					0x02
#define HID_USAGE_KEYBOARD				0x06
#define HID_USAGE_X						0x30
#define HID_USAGE_Y						0x31
#define HID_USAGE_WHEEL					0x38

#pragma pack()

extern bool usb_hid_init( USB_DEVICE * );

#endif // !__USB_CLASS_HID_H__
