/*!
******************************************************************************

	@file	uart.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __UART_H__
#define __UART_H__

#include "task.h"

typedef enum {
	MSG_UART_BASE = TASK_MSG_BASE( TASK_ID_UART ),
	MSG_UART_RECV,	// arg1=(0), arg2=(0)
} UART_EVENT;

#define IO_COM1_RBR				0x3F8	// DLAB=0, R
#define IO_COM1_THR				0x3F8	// DLAB=0, W
#define IO_COM1_DLL				0x3F8	// DLAB=1, R/W
#define IO_COM1_DLH				0x3F9	// DLAB=1, R/W
#define IO_COM1_IER				0x3F9	// DLAB=0, R/W
#define IO_COM1_IIR				0x3FA	// DLAB=x, R
#define IO_COM1_FCR				0x3FA	// DLAB=x, W
#define IO_COM1_LCR				0x3FB	// DLAB=x, R/W
#define IO_COM1_MCR				0x3FC	// DLAB=x, R/W
#define IO_COM1_LSR				0x3FD	// DLAB=x, R
#define IO_COM1_MSR				0x3FE	// DLAB=x, R
#define IO_COM1_SCR				0x3FF	// DLAB=x, R/W

#define IO_COM2_RBR				0x2F8	// DLAB=0, R
#define IO_COM2_THR				0x2F8	// DLAB=0, W
#define IO_COM2_DLL				0x2F8	// DLAB=1, R/W
#define IO_COM2_DLH				0x2F9	// DLAB=1, R/W
#define IO_COM2_IER				0x2F9	// DLAB=0, R/W
#define IO_COM2_IIR				0x2FA	// DLAB=x, R
#define IO_COM2_FCR				0x2FA	// DLAB=x, W
#define IO_COM2_LCR				0x2FB	// DLAB=x, R/W
#define IO_COM2_MCR				0x2FC	// DLAB=x, R/W
#define IO_COM2_LSR				0x2FD	// DLAB=x, R
#define IO_COM2_MSR				0x2FE	// DLAB=x, R
#define IO_COM2_SCR				0x2FF	// DLAB=x, R/W

// IER: 割り込みイネーブル・レジスタ (nF9h)
#define UART_IER_EDSSI			0x08
#define UART_IER_ELSI			0x04
#define UART_IER_ETBEI			0x02
#define UART_IER_ERBFI			0x01
#define UART_IER_NONE			0x00
#define UART_IER_ALL			0x0F

// IIR: 割り込み識別レジスタ (nF9h)
#define UART_IIR_FIFO_ENABLE	0xC0
#define UART_IIR_IID_MASK		0x0F
#define UART_IIR_LINE_STATUS	0x06
#define UART_IIR_RX				0x04
#define UART_IIR_RX_TIMEOUT		0x0C
#define UART_IIR_TX_EMPTY		0x02
#define UART_IIR_MODEM_STATUS	0x00
#define UART_IIR_NONE			0x01

// FCR: FIFO制御レジスタ (nFAh)
#define UART_FCR_TRIG_1BYTE		0x00
#define UART_FCR_TRIG_4BYTES	0x40
#define UART_FCR_TRIG_8BYTES	0x80
#define UART_FCR_TRIG_14BYTES	0xC0
#define UART_FCR_DMA			0x08
#define UART_FCR_TX_RESET		0x04
#define UART_FCR_RX_RESET		0x02
#define UART_FCR_ENABLE			0x01

// LCR: 回線制御レジスタ (nFBh)
#define UART_DLAB				0x80
#define UART_SET_BREAK			0x40
#define UART_STICK_PARITY		0x20
#define UART_PARITY_EVEN		0x18
#define UART_PARITY_ODD			0x08
#define UART_PARITY_NONE		0x00
#define UART_STOP_1BIT			0x00
#define UART_STOP_2BITS			0x04
#define UART_DATA_5BITS			0x00
#define UART_DATA_6BITS			0x01
#define UART_DATA_7BITS			0x02
#define UART_DATA_8BITS			0x03

// MCR: モデム制御レジスタ (nFCh)
#define UART_MCR_LOOP			0x10
#define UART_MCR_OUT2			0x08
#define UART_MCR_OUT1			0x04
#define UART_MCR_RTS			0x02
#define UART_MCR_DTR			0x01

// LSR: 回線ステータスレジスタ (nFDh)
#define UART_LSR_TEMT			0x40
#define UART_LSR_THRE			0x20
#define UART_LSR_BI				0x10
#define UART_LSR_FE				0x08
#define UART_LSR_PE				0x04
#define UART_LSR_OE				0x02
#define UART_LSR_RBF			0x01

extern bool uart_init( u32 baudrate, u8 flags );
extern void uart_task( void *args );
extern void uart_send_char( char c );
extern void uart_send( const char *str );
extern void uart_send_binary( void *p, size_t len );
extern char uart_recv_char( void );

#endif //!__UART_H__
