/*!
******************************************************************************

	@file	date.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "shell.h"
#include "timer.h"

#include <stdio.h>
#include <time.h>

void shell_cmd_date( void )
{
	VSUN86_SYSTEM_TIME t;
	const char *wday[] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
	memset( &t, 0, sizeof(t) );
	timer_get_system_time( &t );
	printf( "%04d/%02d/%02d(%s) %02d:%02d:%02d.%03d GMT\n",
			t.year, t.mon, t.mday, wday[t.wday], t.hour, t.min, t.sec, t.msec );
	timer_get_local_time( &t );
	printf( "%04d/%02d/%02d(%s) %02d:%02d:%02d.%03d JST\n",
			t.year, t.mon, t.mday, wday[t.wday], t.hour, t.min, t.sec, t.msec );
}
