/*!
******************************************************************************

	@file	cpuinfo.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "shell.h"
#include "cpuid.h"

#include <stdio.h>

void shell_cmd_cpuinfo( void )
{
	u32 eax, ebx, ecx, edx, cpuid_max;
	char vendor_id[13];
	char cpu_name[49];

	cpuid_max = cpuid( 0x80000000, &ebx, &ecx, &edx );
	*(u32 *)&vendor_id[0] = ebx;
	*(u32 *)&vendor_id[4] = edx;
	*(u32 *)&vendor_id[8] = ecx;
	vendor_id[12] = '\0';
	printf( "Vendor ID .... \"%s\"\n", vendor_id );

	if ( cpuid_max >= 0x80000004 ) {
		for ( u8 i=0; i<3; i++ ) {
			eax = cpuid( 0x80000002+i, &ebx, &ecx, &edx );
			*(u32 *)&cpu_name[(i<<4)+ 0] = eax;
			*(u32 *)&cpu_name[(i<<4)+ 4] = ebx;
			*(u32 *)&cpu_name[(i<<4)+ 8] = ecx;
			*(u32 *)&cpu_name[(i<<4)+12] = edx;
		}
		cpu_name[48] = '\0';
		eax = cpuid( 0x80000001, &ebx, &ecx, &edx );
		printf( "Model Name ... \"%s\" (%X:%X:%X)\n", cpu_name,
				(eax >> 8) & 0x0F, (eax >> 4) & 0x0F, eax & 0x0F );
	}
}
