/*!
******************************************************************************

	@file	apitest.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "shell.h"
#include "syscall.h"

#include <stdio.h>

void shell_cmd_apitest( void )
{
	VSUN86_VIDEO_INFO video_info;

	// Vsun86_GetVideoInfo()
	memset( &video_info, 0, sizeof(video_info) );
	if ( 0 != Vsun86_GetVideoInfo( &video_info ) ) {
		fprintf( stderr, "Vsun86_GetVideoInfo() failed." );
		return;
	}
	printf( "Vsun86_GetVideoInfo(): width=%d, height=%d, bpp=%d, vram->%08x\n",
			video_info.width, video_info.height, video_info.bpp, video_info.vram );

	// Vsun86_BitBlt()
	u32 color[] = {
		0xFFFFFF, 0x0000FF, 0x00FF00, 0x00FFFF,
		0xFF0000, 0xFF00FF, 0xFFFF00, 0x000000
	};
	u32 *p = (u32 *)video_info.vram;
	const u64 start_tick = Vsun86_GetTickCount();
	for ( u32 n=0; n<256; n++ ) {
		for ( int i=0; i<video_info.width*video_info.height; i++ )
			p[i] = color[n & 0x07];
		Vsun86_BitBlt( p );
	}
	const u64 end_tick = Vsun86_GetTickCount();
	printf( "Vsun86_BitBlt(): %lld ms elapsed.\n", end_tick - start_tick );
}
