/*!
******************************************************************************

	@file	printf.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include <stdarg.h>
#include <stdio.h>

#include "common.h"
#include "printf.h"
#include "shell.h"
#ifndef _VSUN86_PCSIM
#include "uart.h"
#endif	//!_VSUN86_PCSIM

void vmm_printf( int type, const char *fmt, ... )
{
	va_list ap;

	va_start( ap, fmt );
	vmm_vprintf( type, fmt, ap );
	va_end( ap );
}

void vmm_vprintf( int type, const char *fmt, va_list ap )
{
	char buf[256];
	vsnprintf( buf, sizeof(buf), fmt, ap );

	switch( type )
	{
	case VMM_ERROR:
		shell_put_string( buf, COLOR_RED );
#ifndef _VSUN86_PCSIM
		uart_send( "\e[1;31m" );
		uart_send( buf );
		uart_send( "\e[m" );
#else	//_VSUN86_PCSIM
		vprintf( fmt, ap );
#endif	//_VSUN86_PCSIM
		break;

	case VMM_WARNING:
		shell_put_string( buf, COLOR_YELLOW );
#ifndef _VSUN86_PCSIM
		uart_send( "\e[1;33m" );
		uart_send( buf );
		uart_send( "\e[m" );
#else	//_VSUN86_PCSIM
		vprintf( fmt, ap );
#endif	//_VSUN86_PCSIM
		break;

	case VMM_NOTICE:
		shell_put_string( buf, COLOR_GREEN );
#ifndef _VSUN86_PCSIM
		uart_send( "\e[1;32m" );
		uart_send( buf );
		uart_send( "\e[m" );
#else	//_VSUN86_PCSIM
		vprintf( fmt, ap );
#endif	//_VSUN86_PCSIM
		break;

	case VMM_INFO:
		shell_put_string( buf, COLOR_WHITE );
#ifndef _VSUN86_PCSIM
		uart_send( "\e[1;37m" );
		uart_send( buf );
		uart_send( "\e[m" );
#else	//_VSUN86_PCSIM
		vprintf( fmt, ap );
#endif	//_VSUN86_PCSIM
		break;

	case VMM_DEBUG:
//		shell_put_string( buf, COLOR_GREY );
#ifndef _VSUN86_PCSIM
		uart_send( buf );
#else	//_VSUN86_PCSIM
		vprintf( fmt, ap );
#endif	//_VSUN86_PCSIM
		break;
	}
}
